/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.submodel.restapi.operation.AsyncOperationHandler;
import org.eclipse.basyx.submodel.restapi.operation.CallbackResponse;
import org.eclipse.basyx.submodel.restapi.operation.ExecutionState;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.submodel.restapi.operation.InvocationResponse;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class OperationProvider
implements IModelProvider {
    public static final String ASYNC = "?async=true";
    public static final String INVOCATION_LIST = "invocationList";
    public String operationId;
    private IModelProvider modelProvider;

    public OperationProvider(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
        this.operationId = this.getIdShort(modelProvider.getValue(""));
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        String[] splitted = VABPathTools.splitPath(path);
        if (path.isEmpty()) {
            return this.modelProvider.getValue("");
        }
        if (splitted[0].equals(INVOCATION_LIST) && splitted.length == 2) {
            String requestId = splitted[1];
            return AsyncOperationHandler.retrieveResult(requestId, this.operationId);
        }
        throw new MalformedRequestException("Get of an Operation supports only empty or /invocationList/{requestId} paths");
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        throw new MalformedRequestException("Set not allowed at path '" + path + "'");
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws ProviderException {
        String requestId;
        Object[] unwrappedParameters;
        boolean async = path.endsWith(ASYNC);
        path = VABPathTools.stripInvokeFromPath(path);
        InvocationRequest request = this.getInvocationRequest(parameters);
        if (request != null) {
            unwrappedParameters = request.unwrapInputParameters();
            requestId = request.getRequestId();
        } else {
            unwrappedParameters = this.unwrapDirectParameters(parameters);
            requestId = UUID.randomUUID().toString();
        }
        Object childElement = this.modelProvider.getValue(path);
        if (Operation.isOperation(childElement)) {
            path = VABPathTools.concatenatePaths(path, "invokable");
        }
        if (async) {
            Collection<IOperationVariable> outputVars = this.copyOutputVariables();
            VABElementProxy provider = new VABElementProxy(path, this.modelProvider);
            if (request != null) {
                AsyncOperationHandler.invokeAsync(provider, this.operationId, request, outputVars);
            } else {
                AsyncOperationHandler.invokeAsync(provider, this.operationId, requestId, unwrappedParameters, outputVars, 10000);
            }
            return new CallbackResponse(requestId, "");
        }
        Object directResult = this.modelProvider.invokeOperation(path, unwrappedParameters);
        if (request == null) {
            return directResult;
        }
        return this.createInvocationResponseFromDirectResult(request, directResult);
    }

    private Object createInvocationResponseFromDirectResult(InvocationRequest request, Object directResult) {
        Collection<IOperationVariable> outputs = this.copyOutputVariables();
        if (outputs.size() > 0) {
            SubmodelElement outputElem = (SubmodelElement)outputs.iterator().next().getValue();
            outputElem.setValue(directResult);
        }
        return new InvocationResponse(request.getRequestId(), new ArrayList<IOperationVariable>(), outputs, ExecutionState.COMPLETED);
    }

    private InvocationRequest getInvocationRequest(Object[] parameters) {
        if (parameters.length == 1 && parameters[0] instanceof Map) {
            Map requestMap = (Map)parameters[0];
            return InvocationRequest.createAsFacade(requestMap);
        }
        return null;
    }

    private Collection<IOperationVariable> copyOutputVariables() {
        Map operationMap = (Map)this.getValue("");
        Operation op = Operation.createAsFacade(operationMap);
        Collection<IOperationVariable> outputs = op.getOutputVariables();
        ArrayList<IOperationVariable> outCopy = new ArrayList<IOperationVariable>();
        outputs.stream().forEach(o -> outCopy.add(new OperationVariable(o.getValue().getLocalCopy())));
        return outCopy;
    }

    private String getIdShort(Object operation) {
        if (Operation.isOperation(operation)) {
            return Operation.createAsFacade((Map)operation).getIdShort();
        }
        throw new ProviderException("The Object this OperationProvider is pointing to is not an Operation");
    }

    private Object[] unwrapDirectParameters(Object[] parameters) {
        Object[] unwrappedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Map map;
            Object parameter = parameters[i];
            unwrappedParameters[i] = parameter instanceof Map && (map = (Map)parameter).get("valueType") != null && map.containsKey("value") ? map.get("value") : parameter;
        }
        return unwrappedParameters;
    }
}

