/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class PropertyProvider
implements IModelProvider {
    private IModelProvider proxy;

    public PropertyProvider(IModelProvider proxy) {
        this.proxy = proxy;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = VABPathTools.stripSlashes(path)).equals("value")) {
            Map p = (Map)this.proxy.getValue("");
            return p.get("value");
        }
        if (path.isEmpty()) {
            return this.proxy.getValue("");
        }
        throw new MalformedRequestException("Unknown path: " + path);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if (!(path = VABPathTools.stripSlashes(path)).equals("value")) {
            throw new MalformedRequestException("Given Set path '" + path + "' does not end in /value");
        }
        this.proxy.setValue("value", newValue);
        this.proxy.setValue("valueType", ValueTypeHelper.getType(newValue).toString());
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete not allowed at path '" + path + "'");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new MalformedRequestException("Invoke not allowed at path '" + path + "'");
    }
}

