/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.technicaldata.submodelelementcollections.generalinformation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IFile;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.helper.SubmodelElementRetrievalHelper;

public class GeneralInformation
extends SubmodelElementCollection {
    public static final String IDSHORT = "GeneralInformation";
    public static final String MANUFACTURERNAMEID = "ManufacturerName";
    public static final String MANUFACTURERLOGOID = "ManufacturerLogo";
    public static final String MANUFACTURERPRODUCTDESIGNATIONID = "ManufacturerProductDesignation";
    public static final String MANUFACTURERPARTNUMBERID = "ManufacturerPartNumber";
    public static final String MANUFACTURERORDERCODEID = "ManufacturerOrderCode";
    public static final String PRODUCTIMAGEPREFIX = "ProductImage";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/GeneralInformation/1/1", KeyType.IRI));

    private GeneralInformation() {
    }

    public GeneralInformation(Property manufacturerName, MultiLanguageProperty manufacturerProductDesignation, Property manufacturerPartNumber, Property manufacturerOrderCode) {
        this(IDSHORT, manufacturerName, manufacturerProductDesignation, manufacturerPartNumber, manufacturerOrderCode);
    }

    public GeneralInformation(String manufacturerName, LangString manufacturerProductDesignation, String manufacturerPartNumber, String manufacturerOrderCode) {
        this(IDSHORT, manufacturerName, manufacturerProductDesignation, manufacturerPartNumber, manufacturerOrderCode);
    }

    public GeneralInformation(String idShort, Property manufacturerName, MultiLanguageProperty manufacturerProductDesignation, Property manufacturerPartNumber, Property manufacturerOrderCode) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setManufacturerName(manufacturerName);
        this.setManufacturerProductDesignation(manufacturerProductDesignation);
        this.setManufacturerPartNumber(manufacturerPartNumber);
        this.setManufacturerOrderCode(manufacturerOrderCode);
    }

    public GeneralInformation(String idShort, String manufacturerName, LangString manufacturerProductDesignation, String manufacturerPartNumber, String manufacturerOrderCode) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setManufacturerName(manufacturerName);
        this.setManufacturerProductDesignation(manufacturerProductDesignation);
        this.setManufacturerPartNumber(manufacturerPartNumber);
        this.setManufacturerOrderCode(manufacturerOrderCode);
    }

    public static GeneralInformation createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!GeneralInformation.isValid(obj)) {
            throw new MetamodelConstructionException(GeneralInformation.class, obj);
        }
        GeneralInformation generalInformation = new GeneralInformation();
        generalInformation.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return generalInformation;
    }

    private static GeneralInformation createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        GeneralInformation generalInformation = new GeneralInformation();
        generalInformation.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return generalInformation;
    }

    public static boolean isValid(Map<String, Object> obj) {
        GeneralInformation generalInformation = GeneralInformation.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && Property.isValid((Map)((Object)generalInformation.getManufacturerName())) && MultiLanguageProperty.isValid((Map)((Object)generalInformation.getManufacturerProductDesignation())) && Property.isValid((Map)((Object)generalInformation.getManufacturerPartNumber())) && Property.isValid((Map)((Object)generalInformation.getManufacturerOrderCode()));
    }

    public void setManufacturerName(Property name) {
        this.addSubmodelElement(name);
    }

    public void setManufacturerName(String name) {
        Property nameProp = new Property(MANUFACTURERNAMEID, ValueType.String);
        nameProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ManufacturerName/1/1", IdentifierType.IRI)));
        nameProp.setValue(name);
        this.setManufacturerName(nameProp);
    }

    public IProperty getManufacturerName() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERNAMEID)));
    }

    public void setManufacturerLogo(File logo) {
        this.addSubmodelElement(logo);
    }

    public IFile getManufacturerLogo() {
        return File.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERLOGOID)));
    }

    public void setManufacturerProductDesignation(MultiLanguageProperty designation) {
        this.addSubmodelElement(designation);
    }

    public void setManufacturerProductDesignation(LangString designation) {
        MultiLanguageProperty designationProp = new MultiLanguageProperty(MANUFACTURERPRODUCTDESIGNATIONID);
        designationProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ManufacturerProductDesignation/1/1", IdentifierType.IRI)));
        designationProp.setValue(new LangStrings(designation));
        this.setManufacturerProductDesignation(designationProp);
    }

    public IMultiLanguageProperty getManufacturerProductDesignation() {
        return MultiLanguageProperty.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERPRODUCTDESIGNATIONID)));
    }

    public void setManufacturerPartNumber(Property partNumber) {
        this.addSubmodelElement(partNumber);
    }

    public void setManufacturerPartNumber(String partNumber) {
        Property partNumberProp = new Property(MANUFACTURERPARTNUMBERID, ValueType.String);
        partNumberProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ManufacturerPartNumber/1/1", IdentifierType.IRI)));
        partNumberProp.setValue(partNumber);
        this.setManufacturerPartNumber(partNumberProp);
    }

    public IProperty getManufacturerPartNumber() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERPARTNUMBERID)));
    }

    public void setManufacturerOrderCode(Property orderCode) {
        this.addSubmodelElement(orderCode);
    }

    public void setManufacturerOrderCode(String orderCode) {
        Property orderCodeProp = new Property(MANUFACTURERORDERCODEID, ValueType.String);
        orderCodeProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ManufacturerOrderCode/1/1", IdentifierType.IRI)));
        orderCodeProp.setValue(orderCode);
        this.setManufacturerOrderCode(orderCodeProp);
    }

    public IProperty getManufacturerOrderCode() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(MANUFACTURERORDERCODEID)));
    }

    public void setProductImages(List<File> images) {
        if (images != null && images.size() > 0) {
            for (File image : images) {
                this.addSubmodelElement(image);
            }
        }
    }

    public List<IFile> getProductImages() {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(PRODUCTIMAGEPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(File.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }
}

