/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxDockerConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxDocker_";
    public static final int DEFAULT_HOSTPORT = 8082;
    public static final int DEFAULT_CONTAINERPORT = 4000;
    public static final String DEFAULT_IMAGENAME = "basys/component";
    public static final String DEFAULT_CONTAINERNAME = "component";
    public static final String HOSTPORT = "BASYX_HOST_PORT";
    public static final String CONTAINERPORT = "BASYX_CONTAINER_PORT";
    public static final String IMAGENAME = "BASYX_IMAGE_NAME";
    public static final String CONTAINERNAME = "BASYX_CONTAINER_NAME";
    public static final String DEFAULT_CONFIG_PATH = ".env";
    public static final String DEFAULT_FILE_KEY = "BASYX_DOCKER";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(HOSTPORT, Integer.toString(8082));
        defaultProps.put(CONTAINERPORT, Integer.toString(4000));
        defaultProps.put(IMAGENAME, DEFAULT_IMAGENAME);
        defaultProps.put(CONTAINERNAME, DEFAULT_CONTAINERNAME);
        return defaultProps;
    }

    public BaSyxDockerConfiguration() {
        super(BaSyxDockerConfiguration.getDefaultProperties());
    }

    public BaSyxDockerConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxDockerConfiguration(int hostPort, int containerPort, String imageName, String containerName) {
        this();
        this.setHostPort(hostPort);
        this.setContainerPort(containerPort);
        this.setImageName(imageName);
        this.setContainerName(containerName);
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{HOSTPORT, CONTAINERPORT, IMAGENAME, CONTAINERNAME};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public int getHostPort() {
        return Integer.parseInt(this.getProperty(HOSTPORT));
    }

    public void setHostPort(int hostPort) {
        this.setProperty(HOSTPORT, Integer.toString(hostPort));
    }

    public int getContainerPort() {
        return Integer.parseInt(this.getProperty(CONTAINERPORT));
    }

    public void setContainerPort(int containerPort) {
        this.setProperty(CONTAINERPORT, Integer.toString(containerPort));
    }

    public String getImageName() {
        return this.getProperty(IMAGENAME);
    }

    public void setImageName(String imageName) {
        this.setProperty(IMAGENAME, imageName);
    }

    public String getContainerName() {
        return this.getProperty(CONTAINERNAME);
    }

    public void setContainerName(String containerName) {
        this.setProperty(CONTAINERNAME, containerName);
    }
}

