/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.netcomm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.eclipse.basyx.components.netcomm.TCPCommunicator;

public class TCPServer
extends TCPCommunicator
implements Runnable {
    protected int port = -1;
    protected boolean isBlocking = true;
    protected ServerSocketChannel serverSocket = null;

    public TCPServer(int portNo) {
        this.port = portNo;
        try {
            InetAddress hostIPAddress = InetAddress.getByName("localhost");
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.configureBlocking(true);
            this.serverSocket.socket().bind(new InetSocketAddress(hostIPAddress, this.port));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void makeNonBlocking() {
        this.isBlocking = false;
        try {
            this.serverSocket.configureBlocking(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Selector addServerSocket(Selector selector) {
        try {
            this.serverSocket.register(selector, 16);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return selector;
    }

    public void acceptIncomingConnection() throws IOException {
        if (this.communicationToClient != null && this.communicationToClient.isConnected()) {
            return;
        }
        this.communicationToClient = this.serverSocket.accept();
        if (!this.isBlocking) {
            this.communicationToClient.configureBlocking(false);
        }
    }

    public void closeServer() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (!this.isBlocking) {
            throw new RuntimeException("TCP Server communication thread may only be used on blocking sockets.");
        }
        block3: while (true) {
            try {
                while (true) {
                    if (this.communicationToClient == null || !this.communicationToClient.isConnected()) {
                        this.acceptIncomingConnection();
                        continue;
                    }
                    if (!this.serverSocket.isOpen()) break block3;
                    byte[] message = this.readMessage();
                    if (message == null) continue;
                    this.notifyListeners(message);
                }
            }
            catch (ClosedChannelException e) {
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

