/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.RelationshipSource;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.eclipse.basyx.aas.factory.aasx.InMemoryFile;
import org.eclipse.basyx.aas.factory.xml.MetamodelToXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASXFactory {
    private static Logger logger = LoggerFactory.getLogger(AASXFactory.class);
    private static final String MIME_PLAINTXT = "text/plain";
    private static final String MIME_XML = "application/xml";
    private static final String ORIGIN_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aasx-origin";
    private static final String ORIGIN_PATH = "/aasx/aasx-origin";
    private static final String ORIGIN_CONTENT = "Intentionally empty.";
    private static final String AASSPEC_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aas-spec";
    private static final String XML_PATH = "/aasx/xml/content.xml";
    private static final String AASSUPPL_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aas-suppl";

    public static void buildAASX(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList, Collection<InMemoryFile> files, OutputStream os) throws IOException, TransformerException, ParserConfigurationException {
        AASXFactory.prepareFilePaths(submodelList, files);
        OPCPackage rootPackage = OPCPackage.create((OutputStream)os);
        PackagePart origin = AASXFactory.createAASXPart(rootPackage, (RelationshipSource)rootPackage, ORIGIN_PATH, MIME_PLAINTXT, ORIGIN_RELTYPE, ORIGIN_CONTENT.getBytes());
        String xml = AASXFactory.convertToXML(aasList, assetList, conceptDescriptionList, submodelList);
        PackagePart xmlPart = AASXFactory.createAASXPart(rootPackage, (RelationshipSource)origin, XML_PATH, MIME_XML, AASSPEC_RELTYPE, xml.getBytes());
        AASXFactory.storeFilesInAASX(submodelList, files, rootPackage, xmlPart);
        AASXFactory.saveAASX(os, rootPackage);
    }

    private static void storeFilesInAASX(Collection<ISubmodel> submodelList, Collection<InMemoryFile> files, OPCPackage rootPackage, PackagePart xmlPart) {
        for (ISubmodel sm : submodelList) {
            for (File file : AASXFactory.findFileElements(sm.getSubmodelElements().values())) {
                String filePath = file.getValue();
                try {
                    InMemoryFile content = AASXFactory.findFileByPath(files, filePath);
                    logger.trace("Writing file '" + filePath + "' to .aasx.");
                    AASXFactory.createAASXPart(rootPackage, (RelationshipSource)xmlPart, filePath, file.getMimeType(), AASSUPPL_RELTYPE, content.getFileContent());
                }
                catch (ResourceNotFoundException e) {
                    logger.warn("Could not add File '" + filePath + "'. It was not contained in given InMemoryFiles.");
                }
            }
        }
    }

    private static void saveAASX(OutputStream os, OPCPackage rootPackage) throws IOException {
        rootPackage.flush();
        rootPackage.save(os);
    }

    private static String createUniqueID() {
        return "Rid_" + UUID.randomUUID().toString();
    }

    private static PackagePart createAASXPart(OPCPackage root, RelationshipSource relateTo, String path, String mimeType, String relType, byte[] content) {
        if (mimeType == null || mimeType.equals("")) {
            throw new RuntimeException("Could not create AASX Part '" + path + "'. No MIME_TYPE specified.");
        }
        PackagePartName partName = null;
        MemoryPackagePart part = null;
        try {
            partName = PackagingURIHelper.createPartName((String)path);
            part = new MemoryPackagePart(root, partName, mimeType);
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException("Could not create AASX Part '" + path + "'", e);
        }
        AASXFactory.writeDataToPart((PackagePart)part, content);
        root.registerPartAndContentType((PackagePart)part);
        relateTo.addRelationship(partName, TargetMode.EXTERNAL, relType, AASXFactory.createUniqueID());
        return part;
    }

    private static void writeDataToPart(PackagePart part, byte[] content) {
        try (OutputStream ostream = part.getOutputStream();){
            ostream.write(content);
            ostream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write content to AASX Part '" + part.getPartName().getName() + "'", e);
        }
    }

    private static String convertToXML(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList) throws TransformerException, ParserConfigurationException {
        StringWriter writer = new StringWriter();
        MetamodelToXMLConverter.convertToXML(aasList, assetList, conceptDescriptionList, submodelList, new StreamResult(writer));
        return writer.toString();
    }

    private static Collection<File> findFileElements(Collection<ISubmodelElement> elements) {
        ArrayList<File> files = new ArrayList<File>();
        for (ISubmodelElement element : elements) {
            if (element instanceof File) {
                files.add((File)element);
                continue;
            }
            if (!(element instanceof SubmodelElementCollection)) continue;
            files.addAll(AASXFactory.findFileElements(((SubmodelElementCollection)element).getSubmodelElements().values()));
        }
        return files;
    }

    private static Collection<File> findInMemoryFileElements(Collection<ISubmodelElement> elements, Collection<InMemoryFile> inMemoryFiles) {
        Collection<File> files = AASXFactory.findFileElements(elements);
        return files.stream().filter(f -> AASXFactory.isInMemoryFile(inMemoryFiles, f.getValue())).collect(Collectors.toList());
    }

    private static void prepareFilePaths(Collection<ISubmodel> submodels, Collection<InMemoryFile> inMemoryFiles) {
        submodels.stream().forEach(sm -> AASXFactory.findInMemoryFileElements(sm.getSubmodelElements().values(), inMemoryFiles).stream().forEach(f -> f.setValue(AASXFactory.preparePath(f.getValue()))));
    }

    private static String preparePath(String path) {
        String newPath = VABPathTools.getPathFromURL(path);
        if (!newPath.startsWith("/")) {
            newPath = "/" + newPath;
        }
        return newPath;
    }

    private static InMemoryFile findFileByPath(Collection<InMemoryFile> files, String path) {
        for (InMemoryFile file : files) {
            if (!AASXFactory.preparePath(file.getPath()).equals(path)) continue;
            return file;
        }
        throw new ResourceNotFoundException("The wanted file '" + path + "' was not found in the given files.");
    }

    private static boolean isInMemoryFile(Collection<InMemoryFile> files, String path) {
        for (InMemoryFile file : files) {
            if (!VABPathTools.stripSlashes(file.getPath()).equals(VABPathTools.stripSlashes(path))) continue;
            return true;
        }
        return false;
    }
}

