/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.connected;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.IConceptDictionary;
import org.eclipse.basyx.aas.metamodel.api.parts.IView;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.api.security.ISecurity;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.aas.metamodel.map.parts.ConceptDictionary;
import org.eclipse.basyx.aas.metamodel.map.parts.View;
import org.eclipse.basyx.aas.metamodel.map.security.Security;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedElement;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedSubmodel;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.reference.ReferenceHelper;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class ConnectedAssetAdministrationShell
extends ConnectedElement
implements IAssetAdministrationShell {
    public ConnectedAssetAdministrationShell(VABElementProxy proxy) {
        super(proxy);
    }

    public ConnectedAssetAdministrationShell(VABElementProxy proxy, AssetAdministrationShell localCopy) {
        super(proxy);
    }

    public ConnectedAssetAdministrationShell(ConnectedAssetAdministrationShell shell) {
        super(shell.getProxy());
    }

    @Override
    public IAdministrativeInformation getAdministration() {
        return Identifiable.createAsFacade(this.getElem(), this.getKeyElement()).getAdministration();
    }

    @Override
    public IIdentifier getIdentification() {
        return Identifiable.createAsFacade(this.getElem(), this.getKeyElement()).getIdentification();
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this.getElem()).getDataSpecificationReferences();
    }

    @Override
    public Collection<IEmbeddedDataSpecification> getEmbeddedDataSpecifications() {
        return HasDataSpecification.createAsFacade(this.getElem()).getEmbeddedDataSpecifications();
    }

    @Override
    public ISecurity getSecurity() {
        return Security.createAsFacade((Map)this.getElem().getPath("security"));
    }

    @Override
    public IReference getDerivedFrom() {
        return Reference.createAsFacade((Map)this.getElem().getPath("derivedFrom"));
    }

    @Override
    public IAsset getAsset() {
        return Asset.createAsFacade((Map)this.getElem().getPath("asset"));
    }

    @Override
    public Collection<IView> getViews() {
        Collection coll = (Collection)this.getElem().getPath("views");
        return coll.stream().map(View::createAsFacade).collect(Collectors.toSet());
    }

    @Override
    public Collection<IConceptDictionary> getConceptDictionary() {
        Collection set = (Collection)this.getElem().getPath("conceptDictionary");
        return set.stream().map(ConceptDictionary::createAsFacade).collect(Collectors.toSet());
    }

    @Override
    public Map<String, ISubmodel> getSubmodels() {
        Collection submodelCollection = (Collection)this.getProxy().getValue("submodels");
        HashMap<String, ISubmodel> ret = new HashMap<String, ISubmodel>();
        for (Map m : submodelCollection) {
            Submodel sm = Submodel.createAsFacade(m);
            String path = VABPathTools.concatenatePaths("submodels", sm.getIdShort(), "submodel");
            ret.put(sm.getIdShort(), new ConnectedSubmodel(this.getProxy().getDeepProxy(path), sm));
        }
        return ret;
    }

    @Override
    public void addSubmodel(Submodel subModel) {
        subModel.setParent(this.getReference());
        Map<String, Object> convertedMap = SubmodelElementMapCollectionConverter.smToMap(subModel);
        String accessPath = VABPathTools.concatenatePaths("submodels", subModel.getIdShort());
        this.getProxy().setValue(accessPath, convertedMap);
    }

    @Override
    public String getIdShort() {
        return (String)this.getElem().get("idShort");
    }

    @Override
    public String getCategory() {
        return (String)this.getElem().get("category");
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this.getElem(), this.getKeyElement()).getDescription();
    }

    @Override
    public IReference getParent() {
        return Reference.createAsFacade((Map)this.getElem().getPath("parent"));
    }

    @Override
    public Collection<IReference> getSubmodelReferences() {
        return ReferenceHelper.transform(this.getElemLive().getPath("submodels"));
    }

    @Override
    public IReference getAssetReference() {
        return Reference.createAsFacade((Map)this.getElem().getPath("assetRef"));
    }

    private KeyElements getKeyElement() {
        return KeyElements.ASSETADMINISTRATIONSHELL;
    }

    @Override
    public IReference getReference() {
        return Identifiable.createAsFacade(this.getElem(), this.getKeyElement()).getReference();
    }

    public AssetAdministrationShell getLocalCopy() {
        return AssetAdministrationShell.createAsFacade(this.getElem());
    }

    @Override
    public void removeSubmodel(IIdentifier id) {
        ISubmodel sm = this.getSubmodel(id);
        String path = VABPathTools.concatenatePaths("submodels", sm.getIdShort());
        this.getProxy().deleteValue(path);
    }

    @Override
    public ISubmodel getSubmodel(IIdentifier id) {
        Optional<ISubmodel> op = this.getSubmodels().values().stream().filter(sm -> sm.getIdentification().getId().equals(id.getId())).findFirst();
        if (!op.isPresent()) {
            throw new ResourceNotFoundException("AAS " + this.getIdentification() + " does not have a submodel with id " + id);
        }
        return op.get();
    }
}

