/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSubmodelAPI
extends MqttEventService
implements ISubmodelAPI {
    private static Logger logger = LoggerFactory.getLogger(MqttSubmodelAPI.class);
    public static final String TOPIC_CREATESUBMODEL = "BaSyxSubmodel_createdSubmodel";
    public static final String TOPIC_ADDELEMENT = "BaSyxSubmodel_addedSubmodelElement";
    public static final String TOPIC_DELETEELEMENT = "BaSyxSubmodel_removedSubmodelElement";
    public static final String TOPIC_UPDATEELEMENT = "BaSyxSubmodel_updatedSubmodelElement";
    protected ISubmodelAPI observedAPI;
    protected boolean useWhitelist = false;
    protected Set<String> whitelist = new HashSet<String>();

    public MqttSubmodelAPI(ISubmodelAPI observedAPI, String serverEndpoint, String clientId) throws MqttException {
        super(serverEndpoint, clientId);
        logger.info("Create new MQTT submodel for endpoint " + serverEndpoint);
        this.observedAPI = observedAPI;
        this.sendMqttMessage(TOPIC_CREATESUBMODEL, observedAPI.getSubmodel().getIdentification().getId());
    }

    public MqttSubmodelAPI(ISubmodelAPI observedAPI, String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        super(serverEndpoint, clientId, user, pw);
        logger.info("Create new MQTT submodel for endpoint " + serverEndpoint);
        this.observedAPI = observedAPI;
        this.sendMqttMessage(TOPIC_CREATESUBMODEL, observedAPI.getSubmodel().getIdentification().getId());
    }

    public MqttSubmodelAPI(ISubmodelAPI observedAPI, MqttClient client) throws MqttException {
        super(client);
        this.observedAPI = observedAPI;
        this.sendMqttMessage(TOPIC_CREATESUBMODEL, observedAPI.getSubmodel().getIdentification().getId());
    }

    public void observeSubmodelElement(String shortId) {
        this.whitelist.add(VABPathTools.stripSlashes(shortId));
    }

    public void setWhitelist(Set<String> shortIds) {
        this.whitelist.clear();
        for (String entry : shortIds) {
            this.whitelist.add(VABPathTools.stripSlashes(entry));
        }
    }

    public void disableWhitelist() {
        this.useWhitelist = false;
    }

    public void enableWhitelist() {
        this.useWhitelist = true;
    }

    @Override
    public ISubmodel getSubmodel() {
        return this.observedAPI.getSubmodel();
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.observedAPI.addSubmodelElement(elem);
        if (this.filter(elem.getIdShort())) {
            this.sendMqttMessage(TOPIC_ADDELEMENT, MqttSubmodelAPI.getCombinedMessage(this.getAASId(), this.getSubmodelId(), elem.getIdShort()));
        }
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.observedAPI.addSubmodelElement(idShortPath, elem);
        if (this.filter(idShortPath)) {
            this.sendMqttMessage(TOPIC_ADDELEMENT, MqttSubmodelAPI.getCombinedMessage(this.getAASId(), this.getSubmodelId(), idShortPath));
        }
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return this.observedAPI.getSubmodelElement(idShortPath);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.observedAPI.deleteSubmodelElement(idShortPath);
        if (this.filter(idShortPath)) {
            this.sendMqttMessage(TOPIC_DELETEELEMENT, MqttSubmodelAPI.getCombinedMessage(this.getAASId(), this.getSubmodelId(), idShortPath));
        }
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.observedAPI.getOperations();
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        return this.observedAPI.getSubmodelElements();
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.observedAPI.updateSubmodelElement(idShortPath, newValue);
        if (this.filter(idShortPath)) {
            this.sendMqttMessage(TOPIC_UPDATEELEMENT, MqttSubmodelAPI.getCombinedMessage(this.getAASId(), this.getSubmodelId(), idShortPath));
        }
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.observedAPI.getSubmodelElementValue(idShortPath);
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.observedAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.observedAPI.invokeAsync(idShortPath, params);
    }

    @Override
    public Object getOperationResult(String idShort, String requestId) {
        return this.observedAPI.getOperationResult(idShort, requestId);
    }

    public static String getCombinedMessage(String aasId, String submodelId, String elementPart) {
        elementPart = VABPathTools.stripSlashes(elementPart);
        return "(" + aasId + "," + submodelId + "," + elementPart + ")";
    }

    private boolean filter(String idShort) {
        idShort = VABPathTools.stripSlashes(idShort);
        return !this.useWhitelist || this.whitelist.contains(idShort);
    }

    private String getSubmodelId() {
        ISubmodel submodel = this.getSubmodel();
        return submodel.getIdentification().getId();
    }

    private String getAASId() {
        List<IKey> keys;
        ISubmodel submodel = this.getSubmodel();
        IReference parentReference = submodel.getParent();
        if (parentReference != null && (keys = parentReference.getKeys()) != null && keys.size() > 0) {
            return keys.get(0).getValue();
        }
        return null;
    }
}

