/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.qualifier;

import com.google.common.base.Strings;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.qualifier.ReferableXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdentifiableXMLConverter {
    private static final Logger logger = LoggerFactory.getLogger(IdentifiableXMLConverter.class);
    public static final String ADMINISTRATION = "aas:administration";
    public static final String VERSION = "aas:version";
    public static final String REVISION = "aas:revision";
    public static final String IDENTIFICATION = "aas:identification";
    public static final String IDTYPE = "idType";

    public static void populateIdentifiable(Map<String, Object> xmlObject, Identifiable identifiable) {
        ReferableXMLConverter.populateReferable(xmlObject, identifiable);
        Map identierFromXML = (Map)xmlObject.get(IDENTIFICATION);
        if (identierFromXML == null) {
            throw IdentifiableXMLConverter.createInvalidIdentifierException(xmlObject);
        }
        String id = XMLHelper.getString(identierFromXML.get("#text"));
        String idType = XMLHelper.getString(identierFromXML.get(IDTYPE));
        if (Strings.isNullOrEmpty((String)id)) {
            logger.warn("Invalid XML of Identifiable. No valid identification is present. " + xmlObject.toString());
        }
        if (Strings.isNullOrEmpty((String)idType)) {
            logger.warn("Invalid XML of Identifiable. empty identifierType changed to default identifierType Custom. " + xmlObject.toString());
            idType = IdentifierType.CUSTOM.toString();
        }
        if (idType.equalsIgnoreCase("URI")) {
            idType = IdentifierType.IRI.toString();
        }
        identifiable.setIdentification(IdentifierType.fromString(idType), id);
        Map administrationFromXML = (Map)xmlObject.get(ADMINISTRATION);
        if (administrationFromXML != null) {
            String version = XMLHelper.getString(administrationFromXML.get(VERSION));
            String revision = XMLHelper.getString(administrationFromXML.get(REVISION));
            if (!Strings.isNullOrEmpty((String)revision) && Strings.isNullOrEmpty((String)version)) {
                version = "0.0.1";
            }
            identifiable.setAdministration(new AdministrativeInformation(version, revision));
        }
    }

    public static void populateIdentifiableXML(Document document, Element root, IIdentifiable identifiable) {
        ReferableXMLConverter.populateReferableXML(document, root, identifiable);
        if (identifiable.getIdentification() != null) {
            String id = identifiable.getIdentification().getId();
            Element identificationRoot = document.createElement(IDENTIFICATION);
            identificationRoot.appendChild(document.createTextNode(id));
            if (identifiable.getIdentification().getIdType() != null) {
                IdentifierType idType = identifiable.getIdentification().getIdType();
                identificationRoot.setAttribute(IDTYPE, idType.toString());
            }
            root.appendChild(identificationRoot);
        }
        if (identifiable.getAdministration() != null) {
            String revisionString;
            Element version = null;
            Element revision = null;
            String versionString = identifiable.getAdministration().getVersion();
            if (versionString != null && !versionString.isEmpty()) {
                version = document.createElement(VERSION);
                version.appendChild(document.createTextNode(versionString));
            }
            if ((revisionString = identifiable.getAdministration().getRevision()) != null && !revisionString.isEmpty()) {
                revision = document.createElement(REVISION);
                revision.appendChild(document.createTextNode(revisionString));
            }
            if (version != null || revision != null) {
                Element administrationRoot = document.createElement(ADMINISTRATION);
                if (version != null) {
                    administrationRoot.appendChild(version);
                }
                if (revision != null) {
                    administrationRoot.appendChild(revision);
                }
                root.appendChild(administrationRoot);
            }
        }
    }

    private static RuntimeException createInvalidIdentifierException(Map<String, Object> xmlObject) {
        return new RuntimeException("Invalid XML of Identifiable. No valid identification is present. " + xmlObject.toString());
    }
}

