/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.reference;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceXMLConverter {
    public static final String LOCAL = "local";
    public static final String TYPE = "type";
    public static final String IDTYPE = "idType";
    public static final String KEYS = "aas:keys";
    public static final String KEY = "aas:key";

    public static Reference parseReference(Map<String, Object> xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        Reference reference = new Reference();
        reference.setKeys(ReferenceXMLConverter.parseKeys(xmlObject, KEYS, KEY));
        return reference;
    }

    public static Reference parseReference(Map<String, Object> xmlObject, String keysTagName, String keyTagName) {
        Reference reference = new Reference();
        if (xmlObject == null) {
            return reference;
        }
        reference.setKeys(ReferenceXMLConverter.parseKeys(xmlObject, keysTagName, keyTagName));
        return reference;
    }

    private static List<IKey> parseKeys(Map<String, Object> xmlObject, String keysTagName, String keyTagName) {
        ArrayList<IKey> keyList = new ArrayList<IKey>();
        if (xmlObject == null) {
            return keyList;
        }
        Map keysObject = (Map)xmlObject.get(keysTagName);
        if (keysObject == null) {
            return keyList;
        }
        List<Map<String, Object>> xmlKeys = XMLHelper.getList(keysObject.get(keyTagName));
        for (Map<String, Object> xmlKey : xmlKeys) {
            keyList.add(ReferenceXMLConverter.parseKey(xmlKey));
        }
        return keyList;
    }

    private static Key parseKey(Map<String, Object> xmlObject) {
        String text = XMLHelper.getString(xmlObject.get("#text"));
        String idType = XMLHelper.getString(xmlObject.get(IDTYPE));
        String type = XMLHelper.getString(xmlObject.get(TYPE));
        boolean local = Boolean.parseBoolean(XMLHelper.getString(xmlObject.get(LOCAL)));
        if (Strings.isNullOrEmpty((String)idType)) {
            idType = KeyType.CUSTOM.toString();
        }
        if (idType.equalsIgnoreCase("URI")) {
            idType = KeyType.IRI.toString();
        }
        if (Strings.isNullOrEmpty((String)type)) {
            type = KeyElements.REFERENCEELEMENT.toString();
        }
        return new Key(KeyElements.fromString(type), local, text, KeyType.fromString(idType));
    }

    public static Element buildReferencesXML(Document document, Collection<IReference> references) {
        return ReferenceXMLConverter.buildReferencesXML(document, references, KEYS, KEY);
    }

    public static Element buildReferencesXML(Document document, Collection<IReference> references, String keysTagName, String keyTagName) {
        Element xmlKeys = document.createElement(keysTagName);
        if (references == null) {
            return xmlKeys;
        }
        for (IReference reference : references) {
            if (reference == null) continue;
            for (IKey key : reference.getKeys()) {
                xmlKeys.appendChild(ReferenceXMLConverter.buildKey(document, key, keyTagName));
            }
        }
        return xmlKeys;
    }

    public static Element buildReferenceXML(Document document, IReference reference) {
        if (reference == null) {
            return document.createElement(KEYS);
        }
        return ReferenceXMLConverter.buildReferencesXML(document, Arrays.asList(reference), KEYS, KEY);
    }

    public static Element buildReferenceXML(Document document, IReference reference, String keysTagName, String keyTagName) {
        if (reference == null) {
            return document.createElement(keysTagName);
        }
        return ReferenceXMLConverter.buildReferencesXML(document, Arrays.asList(reference), keysTagName, keyTagName);
    }

    private static Element buildKey(Document document, IKey key, String keyTagName) {
        Element xmlKey = document.createElement(keyTagName);
        xmlKey.appendChild(document.createTextNode(key.getValue()));
        xmlKey.setAttribute(IDTYPE, key.getIdType().toString());
        xmlKey.setAttribute(LOCAL, String.valueOf(key.isLocal()));
        xmlKey.setAttribute(TYPE, key.getType().toString());
        return xmlKey;
    }
}

