/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.vab.model.VABModelMap;

public class InvocationRequest
extends VABModelMap<Object> {
    public static final String REQUESTID = "requestId";
    public static final String INOUTARGUMENTS = "inoutputArguments";
    public static final String INPUTARGUMENTS = "inputArguments";
    public static final String TIMEOUT = "timeout";

    private InvocationRequest() {
    }

    public InvocationRequest(String requestId, Collection<IOperationVariable> inoutArguments, Collection<IOperationVariable> inputArguments, int timeout) {
        this.put(REQUESTID, requestId);
        this.put(INOUTARGUMENTS, inoutArguments);
        this.put(INPUTARGUMENTS, inputArguments);
        this.put(TIMEOUT, Integer.valueOf(timeout));
    }

    public static InvocationRequest createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        InvocationRequest ret = new InvocationRequest();
        ret.setRequestId((String)map.get(REQUESTID));
        Collection<IOperationVariable> inoutArguments = InvocationRequest.createInoutArguments(map);
        ret.setInOutArguments(inoutArguments);
        Collection<IOperationVariable> inputArguments = InvocationRequest.createInputArguments(map);
        ret.setInputArguments(inputArguments);
        ret.setTimeout((Integer)map.get(TIMEOUT));
        return ret;
    }

    public Object[] unwrapInputParameters() {
        Collection<IOperationVariable> inputArguments = this.getInputArguments();
        Object[] unwrappedParameters = new Object[inputArguments.size()];
        Iterator<IOperationVariable> iterator = inputArguments.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            IOperationVariable next = iterator.next();
            unwrappedParameters[i] = next.getValue().getValue();
            ++i;
        }
        return unwrappedParameters;
    }

    private static Collection<IOperationVariable> createInputArguments(Map<String, Object> map) {
        Collection inputMap = (Collection)map.get(INPUTARGUMENTS);
        return InvocationRequest.createOperationVariables(inputMap);
    }

    private static Collection<IOperationVariable> createInoutArguments(Map<String, Object> map) {
        Collection inoutMap = (Collection)map.get(INOUTARGUMENTS);
        return InvocationRequest.createOperationVariables(inoutMap);
    }

    private static Collection<IOperationVariable> createOperationVariables(Collection<Map<String, Object>> variableMap) {
        if (variableMap != null) {
            return variableMap.stream().map(OperationVariable::createAsFacade).collect(Collectors.toList());
        }
        return new ArrayList<IOperationVariable>();
    }

    private void setRequestId(String request) {
        this.put(REQUESTID, request);
    }

    private void setInOutArguments(Collection<IOperationVariable> inoutArguments) {
        this.put(INOUTARGUMENTS, inoutArguments);
    }

    private void setInputArguments(Collection<IOperationVariable> inputArguments) {
        this.put(INPUTARGUMENTS, inputArguments);
    }

    private void setTimeout(int timeout) {
        this.put(TIMEOUT, Integer.valueOf(timeout));
    }

    public String getRequestId() {
        return (String)this.get(REQUESTID);
    }

    public Collection<IOperationVariable> getInOutArguments() {
        return (Collection)this.get(INOUTARGUMENTS);
    }

    public Collection<IOperationVariable> getInputArguments() {
        return (Collection)this.get(INPUTARGUMENTS);
    }

    public int getTimeout() {
        return (Integer)this.get(TIMEOUT);
    }
}

