/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.coder.json.connector;

import java.util.Arrays;
import java.util.UUID;
import org.eclipse.basyx.submodel.restapi.operation.InvocationRequest;
import org.eclipse.basyx.vab.coder.json.metaprotocol.IMetaProtocolHandler;
import org.eclipse.basyx.vab.coder.json.metaprotocol.MetaprotocolHandler;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONConnector
implements IModelProvider {
    private static final Logger LOGGER_DEFAULT = LoggerFactory.getLogger(JSONConnector.class);
    private static final Logger LOGGER_COMMUNICATION = LoggerFactory.getLogger((String)(LOGGER_DEFAULT.getName() + ".MALFORMED"));
    protected IBaSyxConnector provider = null;
    protected GSONTools serializer = null;
    protected IMetaProtocolHandler metaProtocolHandler = null;

    public JSONConnector(IBaSyxConnector provider) {
        this.provider = provider;
        this.metaProtocolHandler = new MetaprotocolHandler();
        this.serializer = new GSONTools(new DefaultTypeFactory());
    }

    public JSONConnector(IBaSyxConnector provider, GSONToolsFactory factory) {
        this.provider = provider;
        this.serializer = new GSONTools(factory);
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String message = this.provider.getValue(path);
        try {
            return this.metaProtocolHandler.deserialize(message);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String messageCorrelation = UUID.randomUUID().toString();
            String msg = "Failed to deserialize request for '" + this.provider.getEndpointRepresentation(path) + "' (" + messageCorrelation + ")";
            LOGGER_DEFAULT.warn(msg);
            LOGGER_COMMUNICATION.warn(msg + ": " + message);
            throw new ProviderException(msg, e);
        }
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String jsonString = this.serializer.serialize(newValue);
        String message = this.provider.setValue(path, jsonString);
        this.metaProtocolHandler.deserialize(message);
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String jsonString = this.serializer.serialize(newEntity);
        String message = this.provider.createValue(path, jsonString);
        this.metaProtocolHandler.deserialize(message);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String message = this.provider.deleteValue(path);
        this.metaProtocolHandler.deserialize(message);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String jsonString = this.serializer.serialize(obj);
        String message = this.provider.deleteValue(path, jsonString);
        this.metaProtocolHandler.deserialize(message);
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        String jsonString = parameter.length == 1 && parameter[0] instanceof InvocationRequest ? this.serializer.serialize(parameter[0]) : this.serializer.serialize(Arrays.asList(parameter));
        String message = this.provider.invokeOperation(path, jsonString);
        return this.metaProtocolHandler.deserialize(message);
    }
}

