/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider;

import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VABElementProxy
implements IModelProvider {
    private static Logger logger = LoggerFactory.getLogger(VABElementProxy.class);
    private String addr = "";
    protected IModelProvider provider = null;

    public VABElementProxy(String addr, IModelProvider provider) {
        this.addr = VABPathTools.stripSlashes(addr);
        this.provider = provider;
    }

    @Override
    public Object getValue(String elementPath) throws ProviderException {
        try {
            return this.provider.getValue(this.constructPath(elementPath));
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in getModelPropertyValue", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void setValue(String elementPath, Object newValue) throws ProviderException {
        try {
            this.provider.setValue(this.constructPath(elementPath), newValue);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in setModelPropertyValue", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void createValue(String elementPath, Object newValue) throws ProviderException {
        try {
            this.provider.createValue(this.constructPath(elementPath), newValue);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in createValue", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void deleteValue(String elementPath) throws ProviderException {
        try {
            this.provider.deleteValue(this.constructPath(elementPath));
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in deleteValue", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void deleteValue(String elementPath, Object value) throws ProviderException {
        try {
            this.provider.deleteValue(this.constructPath(elementPath), value);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in deleteValue", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public Object invokeOperation(String elementPath, Object ... parameter) throws ProviderException {
        try {
            return this.provider.invokeOperation(this.constructPath(elementPath), parameter);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("Exception in invokeOperation", (Throwable)e);
            throw new ProviderException(e);
        }
    }

    private String constructPath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = VABPathTools.stripSlashes(path)).isEmpty()) {
            return this.addr;
        }
        if (this.addr != null && !this.addr.isEmpty()) {
            if (path.startsWith("?")) {
                return this.addr + path;
            }
            return this.addr + "/" + path;
        }
        return path;
    }

    public VABElementProxy getDeepProxy(String path) {
        return new VABElementProxy(this.constructPath(path), this.provider);
    }
}

