/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.basyx;

import java.nio.charset.StandardCharsets;

public class CoderTools {
    public static int getInt32(byte[] data, int offset) {
        long result = 0L;
        result += (long)(data[offset + 3] & 0xFF);
        result <<= 8;
        result += (long)(data[offset + 2] & 0xFF);
        result <<= 8;
        result += (long)(data[offset + 1] & 0xFF);
        result <<= 8;
        return (int)(result += (long)(data[offset + 0] & 0xFF));
    }

    public static byte[] setInt32(byte[] data, int offset, int value) {
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 0] = (byte)(value & 0xFF);
        return data;
    }

    public static int getInt16(byte[] data, int offset) {
        int result = 0;
        result += data[offset + 1] & 0xFF;
        result <<= 8;
        return result += data[offset + 0] & 0xFF;
    }

    public static byte[] setInt16(byte[] data, int offset, int value) {
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 0] = (byte)(value & 0xFF);
        return data;
    }

    public static int getInt8(byte[] data, int offset) {
        int result = 0;
        return result += data[offset + 0] & 0xFF;
    }

    public static byte[] setInt8(byte[] data, int offset, int value) {
        data[offset + 0] = (byte)(value & 0xFF);
        return data;
    }

    public static byte[] getByteArray(byte[] data, int offset) {
        byte[] result = new byte[data.length - offset];
        for (int i = offset; i < data.length; ++i) {
            result[i - offset] = data[i];
        }
        return result;
    }

    public static byte[] getByteArray(byte[] data, int offset, int length) {
        byte[] result = new byte[length];
        for (int i = offset; i < offset + length; ++i) {
            result[i - offset] = data[i];
        }
        return result;
    }

    public static byte[] setByteArray(byte[] data, int offset, byte[] newValue) {
        for (int i = 0; i < newValue.length; ++i) {
            data[i + offset] = newValue[i];
        }
        return data;
    }

    public static byte[] setByteArray(byte[] data, int offset, byte[] newValue, int len) {
        for (int i = 0; i < len; ++i) {
            data[i + offset] = newValue[i];
        }
        return data;
    }

    public static String getString(byte[] data, int offset) {
        int cnt = 0;
        StringBuffer str = new StringBuffer();
        while (data[offset + cnt] != 0) {
            str.append(new String(new byte[]{data[offset + cnt]}, StandardCharsets.US_ASCII));
            ++cnt;
        }
        return str.toString();
    }

    public static byte[] setString(byte[] data, int offset, String newValue) {
        for (int i = 0; i < newValue.length(); ++i) {
            data[i + offset] = (byte)newValue.charAt(i);
        }
        return data;
    }
}

