/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.io.File;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxHTTPServer {
    private static Logger logger = LoggerFactory.getLogger(BaSyxHTTPServer.class);
    private Tomcat tomcat = new Tomcat();

    public BaSyxHTTPServer(BaSyxContext context) {
        this.tomcat.getEngine().setName(UUID.randomUUID().toString());
        if (context.isSecuredConnectionEnabled()) {
            Connector httpsConnector = this.tomcat.getConnector();
            this.configureSslConnector(context, httpsConnector);
        } else {
            this.tomcat.setPort(context.port);
        }
        this.tomcat.setHostname(context.hostname);
        this.tomcat.getHost().setAppBase(".");
        File docBase = new File(context.docBasePath);
        Context rootCtx = this.tomcat.addContext(context.contextPath, docBase.getAbsolutePath());
        for (Map.Entry entry : context.entrySet()) {
            String mapping = (String)entry.getKey();
            HttpServlet servlet = (HttpServlet)entry.getValue();
            Tomcat.addServlet((Context)rootCtx, (String)Integer.toString(servlet.hashCode()), (Servlet)servlet);
            rootCtx.addServletMappingDecoded(mapping, Integer.toString(servlet.hashCode()));
        }
    }

    private void configureSslConnector(BaSyxContext context, Connector httpsConnector) {
        httpsConnector.setPort(context.port);
        httpsConnector.setSecure(true);
        httpsConnector.setScheme("https");
        httpsConnector.setAttribute("keystoreFile", (Object)context.getCertificatePath());
        httpsConnector.setAttribute("clientAuth", (Object)"false");
        httpsConnector.setAttribute("sslProtocol", (Object)"TLS");
        httpsConnector.setAttribute("SSLEnabled", (Object)true);
        httpsConnector.setAttribute("protocol", (Object)"HTTP/1.1");
        httpsConnector.setAttribute("keystorePass", (Object)context.getKeyPassword());
        httpsConnector.setAttribute("keyAlias", (Object)"tomcat");
        httpsConnector.setAttribute("maxThreads", (Object)"200");
        httpsConnector.setAttribute("protocol", (Object)"org.apache.coyote.http11.Http11AprProtocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        logger.trace("Starting Tomcat.....");
        Thread serverThread = new Thread(() -> {
            try {
                this.tomcat.stop();
                this.tomcat.getServer().addLifecycleListener(new LifecycleListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void lifecycleEvent(LifecycleEvent event) {
                        if (event.getLifecycle().getState() == LifecycleState.STARTED) {
                            Tomcat tomcat = BaSyxHTTPServer.this.tomcat;
                            synchronized (tomcat) {
                                BaSyxHTTPServer.this.tomcat.notifyAll();
                            }
                        }
                    }
                });
                this.tomcat.start();
                this.tomcat.getServer().await();
            }
            catch (LifecycleException e) {
                logger.error("Failed to start HTTP server.", (Throwable)e);
                Tomcat tomcat = this.tomcat;
                synchronized (tomcat) {
                    this.tomcat.notifyAll();
                }
            }
        });
        serverThread.start();
        EnumSet<LifecycleState> returnStates = EnumSet.of(LifecycleState.STARTED, LifecycleState.FAILED);
        Tomcat tomcat = this.tomcat;
        synchronized (tomcat) {
            try {
                while (!returnStates.contains(this.tomcat.getServer().getState())) {
                    this.tomcat.wait();
                }
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for tomcat to start. Stopping tomcat.", (Throwable)e);
                this.shutdown();
            }
        }
    }

    public void shutdown() {
        logger.trace("Shutting down BaSyx HTTP Server...");
        try {
            this.tomcat.stop();
            this.tomcat.destroy();
        }
        catch (LifecycleException e) {
            logger.error("Exception in shutdown", (Throwable)e);
        }
    }

    public boolean hasEnded() {
        return this.tomcat.getServer().getState() != LifecycleState.STARTED;
    }

    static {
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        if (System.getProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE") == null) {
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
        }
    }
}

