/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.authorization.internal;

import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedTaggedDirectoryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.Authorizers;
import org.eclipse.basyx.components.registry.authorization.internal.IAASRegistryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.IAuthorizersProvider;
import org.eclipse.basyx.components.registry.authorization.internal.ITaggedDirectoryDecorator;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuthorizedAASRegistryFeature<SubjectInformationType>
extends AuthorizedAASRegistryFeature {
    private static Logger logger = LoggerFactory.getLogger(CustomAuthorizedAASRegistryFeature.class);

    public CustomAuthorizedAASRegistryFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public IAASRegistryDecorator getAASRegistryDecorator() {
        logger.info("use Custom authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        IAuthorizersProvider<SubjectInformationType> authorizersProvider = this.getAuthorizersProvider();
        Authorizers<SubjectInformationType> authorizers = authorizersProvider.get(this.securityConfig);
        return new AuthorizedAASRegistryDecorator<SubjectInformationType>(authorizers.getAasRegistryAuthorizer(), subjectInformationProvider);
    }

    @Override
    public ITaggedDirectoryDecorator getTaggedDirectoryDecorator() {
        logger.info("use Custom authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        IAuthorizersProvider<SubjectInformationType> authorizersProvider = this.getAuthorizersProvider();
        Authorizers<SubjectInformationType> authorizers = authorizersProvider.get(this.securityConfig);
        return new AuthorizedTaggedDirectoryDecorator<SubjectInformationType>(authorizers.getTaggedDirectoryAuthorizer(), subjectInformationProvider);
    }

    private IAuthorizersProvider<SubjectInformationType> getAuthorizersProvider() {
        return (IAuthorizersProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.custom.authorizersProvider", IAuthorizersProvider.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getSubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.custom.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

