/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.executable;

import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.registry.RegistryComponent;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryEventBackend;

public class RegistryExecutable {
    private RegistryExecutable() {
    }

    public static void main(String[] args) {
        BaSyxContextConfiguration contextConfig = new BaSyxContextConfiguration();
        contextConfig.loadFromDefaultSource();
        BaSyxRegistryConfiguration registryConfig = new BaSyxRegistryConfiguration();
        registryConfig.loadFromDefaultSource();
        RegistryComponent component = new RegistryComponent(contextConfig, registryConfig);
        RegistryExecutable.setMqttConfiguration(registryConfig, component);
        RegistryExecutable.addShutdownHook(component);
        component.startComponent();
    }

    private static void setMqttConfiguration(BaSyxRegistryConfiguration registryConfig, RegistryComponent component) {
        if (RegistryExecutable.isMqttBackendSelected(registryConfig)) {
            BaSyxMqttConfiguration mqttConfig = new BaSyxMqttConfiguration();
            mqttConfig.loadFromDefaultSource();
            component.enableMQTT(mqttConfig);
        }
    }

    private static boolean isMqttBackendSelected(BaSyxRegistryConfiguration registryConfig) {
        return registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTT) || registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTTV2);
    }

    private static void addShutdownHook(IComponent component) {
        Thread shutdownListener = new Thread(() -> component.stopComponent());
        Runtime.getRuntime().addShutdownHook(shutdownListener);
    }
}

