/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.aas.restapi.vab.VABAASAPIFactory;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;

public class AASAggregator
implements IAASAggregator {
    protected Map<String, MultiSubmodelProvider> aasProviderMap = new LinkedHashMap<String, MultiSubmodelProvider>();
    protected IAASRegistry registry;
    protected IAASAPIFactory aasApiFactory;
    protected ISubmodelAggregatorFactory submodelAggregatorFactory;

    public AASAggregator(IAASAPIFactory aasApiFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this.aasApiFactory = aasApiFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
    }

    public AASAggregator(IAASAPIFactory aasApiFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, IAASRegistry registry) {
        this(aasApiFactory, submodelAggregatorFactory);
        this.registry = registry;
    }

    public AASAggregator(IAASAPIFactory aasApiFactory, ISubmodelAPIFactory submodelApiFactory, IAASRegistry registry) {
        this(aasApiFactory, new SubmodelAggregatorFactory(submodelApiFactory), registry);
    }

    public AASAggregator() {
        this((IAASAPIFactory)new VABAASAPIFactory(), new SubmodelAggregatorFactory());
    }

    public AASAggregator(IAASAPIFactory aasApiFactory, ISubmodelAPIFactory submodelApiFactory) {
        this(aasApiFactory, new SubmodelAggregatorFactory(submodelApiFactory));
    }

    public AASAggregator(IAASRegistry registry) {
        this((IAASAPIFactory)new VABAASAPIFactory(), new SubmodelAggregatorFactory(), registry);
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasProviderMap.values().stream().map(p -> {
            try {
                return p.getValue("/aas");
            }
            catch (NotAuthorizedException e) {
                return null;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        }).filter(Objects::nonNull).map(m -> {
            AssetAdministrationShell aas = new AssetAdministrationShell();
            aas.putAll((Map)m);
            return aas;
        }).collect(Collectors.toList());
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) {
        IModelProvider aasProvider = this.getAASProvider(aasId);
        Map aasMap = (Map)aasProvider.getValue("/aas");
        AssetAdministrationShell aas = AssetAdministrationShell.createAsFacade(aasMap);
        return aas;
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.aasProviderMap.put(aas.getIdentification().getId(), this.createMultiSubmodelProvider(aas));
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) {
        MultiSubmodelProvider oldProvider = (MultiSubmodelProvider)this.getAASProvider(aas.getIdentification());
        IAASAPI aasApi = this.aasApiFactory.create(aas);
        AASModelProvider contentProvider = new AASModelProvider(aasApi);
        IConnectorFactory connectorFactory = oldProvider.getConnectorFactory();
        MultiSubmodelProvider updatedProvider = new MultiSubmodelProvider(contentProvider, this.registry, connectorFactory, this.aasApiFactory, oldProvider.getSmAggregator());
        this.aasProviderMap.put(aas.getIdentification().getId(), updatedProvider);
    }

    private MultiSubmodelProvider createMultiSubmodelProvider(AssetAdministrationShell aas) {
        HTTPConnectorFactory connectorFactory = new HTTPConnectorFactory();
        IAASAPI aasApi = this.aasApiFactory.create(aas);
        AASModelProvider contentProvider = new AASModelProvider(aasApi);
        return new MultiSubmodelProvider(contentProvider, this.registry, (IConnectorFactory)connectorFactory, this.aasApiFactory, this.submodelAggregatorFactory.create(aas.getIdentification()));
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        this.aasProviderMap.remove(aasId.getId());
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) {
        MultiSubmodelProvider provider = this.aasProviderMap.get(aasId.getId());
        if (provider == null) {
            throw new ResourceNotFoundException("AAS with Id " + aasId.getId() + " does not exist");
        }
        return provider;
    }
}

