/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator;

import org.eclipse.basyx.aas.aggregator.AASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;

public class AASAggregatorFactory
implements IAASAggregatorFactory {
    private IAASAPIFactory aasApiFactory;
    private ISubmodelAggregatorFactory submodelAggregatorFactory;
    private IAASRegistry registry;
    private ISubmodelAPIFactory submodelApiFactory;

    public AASAggregatorFactory() {
    }

    public AASAggregatorFactory(IAASAPIFactory aasApiFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this.aasApiFactory = aasApiFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
    }

    public AASAggregatorFactory(IAASAPIFactory aasApiFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, IAASRegistry registry) {
        this.aasApiFactory = aasApiFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.registry = registry;
    }

    public AASAggregatorFactory(IAASAPIFactory aasApiFactory, ISubmodelAPIFactory submodelApiFactory) {
        this.aasApiFactory = aasApiFactory;
        this.submodelApiFactory = submodelApiFactory;
    }

    public AASAggregatorFactory(IAASAPIFactory aasApiFactory, ISubmodelAPIFactory submodelApiFactory, IAASRegistry registry) {
        this.aasApiFactory = aasApiFactory;
        this.submodelApiFactory = submodelApiFactory;
        this.registry = registry;
    }

    public AASAggregatorFactory(IAASRegistry registry) {
        this.registry = registry;
    }

    @Override
    public IAASAggregator create() {
        return this.constructAASAggregatorWithGivenArguments();
    }

    private IAASAggregator constructAASAggregatorWithGivenArguments() {
        if (this.isRegistrySet() && this.isAasApiAndSubmodelAggregatorSet()) {
            return new AASAggregator(this.aasApiFactory, this.submodelAggregatorFactory, this.registry);
        }
        if (this.isRegistrySet() && this.isAasApiAndSubmodelApiSet()) {
            return new AASAggregator(this.aasApiFactory, this.submodelApiFactory, this.registry);
        }
        if (this.isOnlyRegistrySet()) {
            return new AASAggregator(this.registry);
        }
        if (this.isAasApiAndSubmodelAggregatorSet()) {
            return new AASAggregator(this.aasApiFactory, this.submodelAggregatorFactory);
        }
        if (this.isAasApiAndSubmodelApiSet()) {
            return new AASAggregator(this.aasApiFactory, this.submodelApiFactory);
        }
        return new AASAggregator();
    }

    private boolean isRegistrySet() {
        return this.registry != null;
    }

    private boolean isAasApiAndSubmodelAggregatorSet() {
        return this.aasApiFactory != null && this.submodelAggregatorFactory != null;
    }

    private boolean isAasApiAndSubmodelApiSet() {
        return this.aasApiFactory != null && this.submodelApiFactory != null;
    }

    private boolean isOnlyRegistrySet() {
        return this.isRegistrySet() && this.aasApiFactory == null && this.submodelAggregatorFactory == null && this.submodelApiFactory == null;
    }
}

