/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator.proxy;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.connected.ConnectedAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASAggregatorProxy
implements IAASAggregator {
    protected IModelProvider provider;
    private static Logger logger = LoggerFactory.getLogger(AASRegistryProxy.class);

    public AASAggregatorProxy(String aasAggregatorURL) {
        this(new JSONConnector(new HTTPConnector(AASAggregatorProxy.harmonizeURL(aasAggregatorURL))));
    }

    public AASAggregatorProxy(IModelProvider provider) {
        this.provider = new VABElementProxy("", provider);
    }

    protected static String harmonizeURL(String url) {
        return AASAggregatorAPIHelper.harmonizeURL(url);
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        Collection collection = (Collection)this.provider.getValue(AASAggregatorAPIHelper.getAggregatorPath());
        logger.debug("Getting all AAS");
        return collection.stream().map(m -> AssetAdministrationShell.createAsFacade(m)).map(aas -> this.getConnectedAAS(aas.getIdentification(), (AssetAdministrationShell)aas)).collect(Collectors.toList());
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier aasId) {
        logger.debug("Getting AAS with id " + aasId);
        return this.getConnectedAAS(aasId);
    }

    private ConnectedAssetAdministrationShell getConnectedAAS(IIdentifier aasId) {
        VABElementProxy proxy = this.getAASProxy(aasId);
        Map map = (Map)proxy.getValue("");
        AssetAdministrationShell aas = AssetAdministrationShell.createAsFacade(map);
        return new ConnectedAssetAdministrationShell(proxy, aas);
    }

    private ConnectedAssetAdministrationShell getConnectedAAS(IIdentifier aasId, AssetAdministrationShell localCopy) {
        VABElementProxy proxy = this.getAASProxy(aasId);
        return new ConnectedAssetAdministrationShell(proxy, localCopy);
    }

    private VABElementProxy getAASProxy(IIdentifier aasId) {
        String path = AASAggregatorAPIHelper.getAASAccessPath(aasId);
        VABElementProxy proxy = new VABElementProxy(path, this.provider);
        return proxy;
    }

    @Override
    public void createAAS(AssetAdministrationShell aas) {
        this.provider.setValue(AASAggregatorAPIHelper.getAASEntryPath(aas.getIdentification()), aas);
        logger.info("AAS with Id " + aas.getIdentification().getId() + " created");
    }

    @Override
    public void updateAAS(AssetAdministrationShell aas) {
        this.provider.setValue(AASAggregatorAPIHelper.getAASEntryPath(aas.getIdentification()), aas);
        logger.info("AAS with Id " + aas.getIdentification().getId() + " updated");
    }

    @Override
    public void deleteAAS(IIdentifier aasId) {
        this.provider.deleteValue(AASAggregatorAPIHelper.getAASEntryPath(aasId));
        logger.info("AAS with Id " + aasId.getId() + " deleted");
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier aasId) {
        return new VABElementProxy(AASAggregatorAPIHelper.getAASEntryPath(aasId), this.provider);
    }
}

