/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.json;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleFactory;
import org.eclipse.basyx.aas.factory.json.JSONToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;

public class JSONAASBundleFactory {
    private String content;

    public JSONAASBundleFactory(String jsonContent) {
        this.content = jsonContent;
    }

    public JSONAASBundleFactory(Path jsonFile) throws IOException {
        this.content = new String(Files.readAllBytes(jsonFile));
    }

    public Set<AASBundle> create() {
        JSONToMetamodelConverter converter = new JSONToMetamodelConverter(this.content);
        List<AssetAdministrationShell> shells = converter.parseAAS();
        List<Submodel> submodels = converter.parseSubmodels();
        List<Asset> assets = converter.parseAssets();
        return new AASBundleFactory().create(shells, submodels, assets);
    }
}

