/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.xml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleFactory;
import org.eclipse.basyx.aas.factory.xml.XMLToMetamodelConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.xml.sax.SAXException;

public class XMLAASBundleFactory {
    private String content;

    public XMLAASBundleFactory(String xmlContent) {
        this.content = xmlContent;
    }

    public XMLAASBundleFactory(Path xmlFile) throws IOException {
        this.content = new String(Files.readAllBytes(xmlFile));
    }

    public Set<AASBundle> create() throws ParserConfigurationException, SAXException, IOException {
        XMLToMetamodelConverter converter = new XMLToMetamodelConverter(this.content);
        List<IAssetAdministrationShell> shells = converter.parseAAS();
        List<ISubmodel> submodels = converter.parseSubmodels();
        List<IAsset> assets = converter.parseAssets();
        return new AASBundleFactory().create(shells, submodels, assets);
    }
}

