/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal;

import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal.ITaggedDirectoryAuthorizer;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.SimpleRbacAASRegistryAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.TagTargetInformation;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;

public class SimpleRbacTaggedDirectoryAuthorizer<SubjectInformationType>
extends SimpleRbacAASRegistryAuthorizer<SubjectInformationType>
implements ITaggedDirectoryAuthorizer<SubjectInformationType> {
    public SimpleRbacTaggedDirectoryAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        super(rbacRuleChecker, roleAuthenticator);
    }

    @Override
    public void authorizeRegister(SubjectInformationType subjectInformation, IIdentifier aasId, TaggedAASDescriptor taggedAASDescriptor) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null, null));
    }

    @Override
    public Set<TaggedAASDescriptor> authorizeLookupTag(SubjectInformationType subjectInformation, String tag, Supplier<Set<TaggedAASDescriptor>> taggedAASDescriptorsSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new TagTargetInformation(tag));
        return taggedAASDescriptorsSupplier.get();
    }

    @Override
    public Set<TaggedAASDescriptor> authorizeLookupTags(SubjectInformationType subjectInformation, Set<String> tags, Supplier<Set<TaggedAASDescriptor>> taggedAASDescriptorsSupplier) throws InhibitException {
        return taggedAASDescriptorsSupplier.get();
    }

    @Override
    public void authorizeRegisterSubmodel(SubjectInformationType subjectInformation, IIdentifier aasId, IIdentifier smId, IReference smSemanticId, TaggedSubmodelDescriptor taggedSubmodelDescriptor) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
    }

    @Override
    public Set<TaggedSubmodelDescriptor> authorizeLookupSubmodelTag(SubjectInformationType subjectInformation, String submodelTag, Supplier<Set<TaggedSubmodelDescriptor>> taggedSubmodelDescriptorsSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-registry:read", new TagTargetInformation(submodelTag));
        return taggedSubmodelDescriptorsSupplier.get();
    }

    @Override
    public Set<TaggedSubmodelDescriptor> authorizeLookupSubmodelTags(SubjectInformationType subjectInformation, Set<String> submodelTags, Supplier<Set<TaggedSubmodelDescriptor>> taggedSubmodelDescriptorsSupplier) throws InhibitException {
        return taggedSubmodelDescriptorsSupplier.get();
    }

    @Override
    public Set<TaggedSubmodelDescriptor> authorizeLookupBothAasAndSubmodelTags(SubjectInformationType subjectInformation, Set<String> aasTags, Set<String> submodelTags, Supplier<Set<TaggedSubmodelDescriptor>> taggedSubmodelDescriptorsSupplier) throws InhibitException {
        return taggedSubmodelDescriptorsSupplier.get();
    }
}

