/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.authorization.internal;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.extensions.submodel.authorization.internal.ISubmodelAPIAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;

public class SimpleRbacSubmodelAPIAuthorizer<SubjectInformationType>
implements ISubmodelAPIAuthorizer<SubjectInformationType> {
    protected IRbacRuleChecker rbacRuleChecker;
    protected IRoleAuthenticator<SubjectInformationType> roleAuthenticator;

    public SimpleRbacSubmodelAPIAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        this.rbacRuleChecker = rbacRuleChecker;
        this.roleAuthenticator = roleAuthenticator;
    }

    @Override
    public Collection<ISubmodelElement> authorizeGetSubmodelElements(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, Supplier<ISubmodel> smSupplier, Supplier<Collection<ISubmodelElement>> smElListSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
        return smElListSupplier.get();
    }

    @Override
    public ISubmodelElement authorizeGetSubmodelElement(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath, Supplier<ISubmodelElement> smElSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
        return smElSupplier.get();
    }

    @Override
    public ISubmodel authorizeGetSubmodel(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, Supplier<ISubmodel> smSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
        return smSupplier.get();
    }

    @Override
    public void authorizeAddSubmodelElement(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
    }

    @Override
    public void authorizeDeleteSubmodelElement(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
    }

    @Override
    public void authorizeUpdateSubmodelElement(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
    }

    @Override
    public Object authorizeGetSubmodelElementValue(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath, Supplier<Object> valueSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
        return valueSupplier.get();
    }

    @Override
    public Collection<IOperation> authorizeGetOperations(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, Supplier<ISubmodel> smSupplier, Supplier<Collection<IOperation>> operationListSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), null));
        return operationListSupplier.get();
    }

    @Override
    public void authorizeInvokeOperation(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:execute", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
    }

    @Override
    public Object authorizeGetOperationResult(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, IReference smSemanticId, String smElIdShortPath, String requestId, Supplier<Object> operationResultSupplier) throws InhibitException {
        IIdentifier aasId = this.getAasId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-api:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), IdHelper.getReferenceId(smSemanticId), smElIdShortPath));
        return operationResultSupplier.get();
    }

    private IIdentifier getAasId(IAssetAdministrationShell aas) {
        return aas != null ? aas.getIdentification() : null;
    }
}

