/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import java.util.List;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.restapi.observing.ObservableSubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttSubmodelAPIHelper {
    public static final String TOPIC_CREATESUBMODEL = "BaSyxSubmodel_createdSubmodel";
    public static final String TOPIC_ADDELEMENT = "BaSyxSubmodel_addedSubmodelElement";
    public static final String TOPIC_DELETEELEMENT = "BaSyxSubmodel_removedSubmodelElement";
    public static final String TOPIC_UPDATEELEMENT = "BaSyxSubmodel_updatedSubmodelElement";

    public static IIdentifier getSubmodelId(ObservableSubmodelAPI observedAPI) {
        ISubmodel submodel = observedAPI.getSubmodel();
        return submodel.getIdentification();
    }

    public static IIdentifier getAASId(ObservableSubmodelAPI observedAPI) {
        List<IKey> keys;
        ISubmodel submodel = observedAPI.getSubmodel();
        IReference parentReference = submodel.getParent();
        if (parentReference != null && MqttSubmodelAPIHelper.doesKeysExists(keys = parentReference.getKeys())) {
            return MqttSubmodelAPIHelper.createIdentifier(keys);
        }
        return null;
    }

    public static String createChangedSubmodelPayload(String submodelId) {
        return submodelId;
    }

    public static String createChangedSubmodelElementPayload(String aasId, String submodelId, String elementPart) {
        elementPart = VABPathTools.stripSlashes(elementPart);
        return "(" + aasId + "," + submodelId + "," + elementPart + ")";
    }

    private static boolean doesKeysExists(List<IKey> keys) {
        return keys != null && !keys.isEmpty();
    }

    private static IIdentifier createIdentifier(List<IKey> keys) {
        return new Identifier(IdentifierType.fromString(keys.get(0).getIdType().toString()), keys.get(0).getValue());
    }

    public static MqttConnectOptions getMqttConnectOptions(String username, char[] password) {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setUserName(username);
        options.setPassword(password);
        return options;
    }
}

