/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.qualifier;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LangStringsXMLConverter {
    public static final String LANG = "lang";
    public static final String LANG_STRING = "aas:langString";

    public static LangStrings parseLangStrings(Map<String, Object> xmlObject) {
        return LangStringsXMLConverter.parseLangStrings(xmlObject, LANG_STRING);
    }

    public static LangStrings parseLangStrings(Object obj, String tagName) {
        if (obj == null) {
            return new LangStrings();
        }
        if (obj instanceof Map) {
            return LangStringsXMLConverter.parseLangStringsFromMap((Map)obj, tagName);
        }
        return LangStringsXMLConverter.parseLangStringsFromString((String)obj);
    }

    private static LangStrings parseLangStringsFromString(String str) {
        LangString langString = new LangString("EN", str);
        return new LangStrings(langString);
    }

    private static LangStrings parseLangStringsFromMap(Map<String, Object> xmlObject, String tagName) {
        LangStrings langStrings = new LangStrings();
        if (xmlObject != null) {
            List<Map<String, Object>> xmlLangStrings = XMLHelper.getList(xmlObject.get(tagName));
            for (Map<String, Object> xmlLangString : xmlLangStrings) {
                String text = XMLHelper.getString(xmlLangString.get("#text"));
                String lang = XMLHelper.getString(xmlLangString.get(LANG));
                langStrings.add(new LangString(lang, text));
            }
        }
        return langStrings;
    }

    public static void buildLangStringsXML(Document document, Element root, LangStrings langStrings) {
        LangStringsXMLConverter.buildLangStringsXML(document, root, LANG_STRING, langStrings);
    }

    public static void buildLangStringsXML(Document document, Element root, String tagName, LangStrings langStrings) {
        if (langStrings != null) {
            Set<String> languages = langStrings.getLanguages();
            for (String language : languages) {
                Element langStringRoot = document.createElement(tagName);
                String text = langStrings.get(language);
                langStringRoot.setAttribute(LANG, language);
                langStringRoot.appendChild(document.createTextNode(text));
                root.appendChild(langStringRoot);
            }
        }
    }
}

