/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.technicaldata.submodelelementcollections.technicalproperties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.types.helper.SubmodelElementRetrievalHelper;

public class TechnicalProperties
extends SubmodelElementCollection {
    public static final String IDSHORT = "TechnicalProperties";
    public static final String MAINSECTIONPREFIX = "MainSection";
    public static final String SUBSECTIONPREFIX = "SubSection";
    public static final String SMENOTDESCRIBEDID = "https://admin-shell.io/SemanticIdNotAvailable/1/1";
    public static final String MAINSECTIONID = "https://admin-shell.io/ZVEI/TechnicalData/MainSection/1/1";
    public static final String SUBSECTIONID = "https://admin-shell.io/ZVEI/TechnicalData/SubSection/1/1";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/TechnicalProperties/1/1", KeyType.IRI));

    public TechnicalProperties() {
        this(IDSHORT);
    }

    public TechnicalProperties(String idShort) {
        super(idShort);
    }

    public static TechnicalProperties createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!TechnicalProperties.isValid(obj)) {
            throw new MetamodelConstructionException(TechnicalProperties.class, obj);
        }
        TechnicalProperties technicalProperties = new TechnicalProperties();
        technicalProperties.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return technicalProperties;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElementCollection.isValid(obj);
    }

    public void setArbitrary(List<SubmodelElement> elements) {
        if (elements != null && elements.size() > 0) {
            for (SubmodelElement elem : elements) {
                this.addSubmodelElement(elem);
            }
        }
    }

    public List<ISubmodelElement> getArbitrary() {
        return this.getSubmodelElements().values().stream().filter(x -> {
            String id = x.getSemanticId().getKeys().get(0).getValue();
            return !id.equals(MAINSECTIONID) && !id.equals(SUBSECTIONID) && !id.equals(SMENOTDESCRIBEDID);
        }).collect(Collectors.toList());
    }

    public void setSMENotDescribedBySemanticId(List<SubmodelElement> elements) {
        if (elements != null && elements.size() > 0) {
            for (SubmodelElement elem : elements) {
                this.addSubmodelElement(elem);
            }
        }
    }

    public List<ISubmodelElement> getSMENotDescribedBySemanticId() {
        return this.getSubmodelElements().values().stream().filter(x -> x.getSemanticId().getKeys().get(0).getValue().equals(SMENOTDESCRIBEDID)).collect(Collectors.toList());
    }

    public void setMainSections(List<SubmodelElementCollection> mainSections) {
        if (mainSections != null && mainSections.size() > 0) {
            for (SubmodelElementCollection section : mainSections) {
                this.addSubmodelElement(section);
            }
        }
    }

    public List<ISubmodelElementCollection> getMainSections() {
        ArrayList<ISubmodelElementCollection> ret = new ArrayList<ISubmodelElementCollection>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(MAINSECTIONPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(SubmodelElementCollection.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }

    public void setSubSections(List<SubmodelElementCollection> subSections) {
        if (subSections != null && subSections.size() > 0) {
            for (SubmodelElementCollection section : subSections) {
                this.addSubmodelElement(section);
            }
        }
    }

    public List<ISubmodelElementCollection> getSubSections() {
        ArrayList<ISubmodelElementCollection> ret = new ArrayList<ISubmodelElementCollection>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(SUBSECTIONPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(SubmodelElementCollection.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }
}

