/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.filesystem.filesystem;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.File;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.FileSystem;
import org.eclipse.basyx.vab.modelprovider.filesystem.filesystem.FileType;

public class GenericFileSystem
implements FileSystem {
    @Override
    public String readFile(String path) throws IOException {
        path = this.toLowerCase(path);
        return new String(Files.readAllBytes(this.getPath(path)), StandardCharsets.UTF_8);
    }

    @Override
    public void writeFile(String path, String content) throws IOException {
        path = this.toLowerCase(path);
        FileWriter f = new FileWriter(path, false);
        f.write(content);
        f.close();
    }

    @Override
    public void deleteFile(String path) throws IOException {
        path = this.toLowerCase(path);
        Files.deleteIfExists(this.getPath(path));
    }

    @Override
    public void createDirectory(String path) throws IOException {
        path = this.toLowerCase(path);
        Files.createDirectories(this.getPath(path), new FileAttribute[0]);
    }

    @Override
    public List<File> readDirectory(String path) throws IOException {
        path = this.toLowerCase(path);
        ArrayList<File> files = new ArrayList<File>();
        try (Stream<Path> directory = Files.list(this.getPath(path));){
            files.addAll(directory.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> new File(this.restoreCase(p.toString().replace("\\", "/")), FileType.DATA)).collect(Collectors.toList()));
        }
        directory = Files.list(this.getPath(path));
        try {
            files.addAll(directory.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> new File(this.restoreCase(p.toString().replace("\\", "/")), FileType.DIRECTORY)).collect(Collectors.toList()));
        }
        finally {
            if (directory != null) {
                directory.close();
            }
        }
        return files;
    }

    @Override
    public void deleteDirectory(String path) throws IOException {
        path = this.toLowerCase(path);
        try {
            Files.walk(this.getPath(path), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(p -> p.toFile()).forEach(f -> f.delete());
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Override
    public FileType getType(String path) {
        if (!Files.exists(this.getPath(path = this.toLowerCase(path)), new LinkOption[0])) {
            return null;
        }
        if (Files.isDirectory(this.getPath(path), new LinkOption[0])) {
            return FileType.DIRECTORY;
        }
        return FileType.DATA;
    }

    private Path getPath(String path) {
        return FileSystems.getDefault().getPath(path, new String[0]);
    }

    private String toLowerCase(String path) {
        return path.replaceAll("([A-Z_])", "_$1").toLowerCase();
    }

    private String restoreCase(String path) {
        StringBuffer result = new StringBuffer();
        Matcher m = Pattern.compile("_([_a-z])").matcher(path);
        while (m.find()) {
            m.appendReplacement(result, m.group(1).toUpperCase());
        }
        m.appendTail(result);
        return result.toString();
    }
}

