/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.generic;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.basyx.vab.exception.provider.NotAnInvokableException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceAlreadyExistsException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.generic.IVABElementHandler;

public class VABModelProvider
implements IModelProvider {
    private IVABElementHandler handler;
    protected Object elements;

    public VABModelProvider(Object elements, IVABElementHandler handler) {
        this.handler = handler;
        this.elements = elements;
    }

    @Override
    public Object getValue(String path) {
        Object element = this.getTargetElement(path);
        return this.handler.postprocessObject(element);
    }

    @Override
    public void setValue(String path, Object newValue) {
        VABPathTools.checkPathForNull(path);
        if (VABPathTools.isEmptyPath(path)) {
            if (this.elements != null) {
                this.elements = newValue;
            }
            return;
        }
        Object parentElement = this.getParentElement(path);
        String propertyName = VABPathTools.getLastElement(path);
        this.handler.getElementProperty(parentElement, propertyName);
        this.handler.setModelPropertyValue(parentElement, propertyName, newValue);
    }

    @Override
    public void createValue(String path, Object newValue) {
        VABPathTools.checkPathForNull(path);
        if (VABPathTools.isEmptyPath(path)) {
            if (this.elements != null) {
                throw new ResourceAlreadyExistsException("Root element does already exist.");
            }
            this.elements = newValue;
            return;
        }
        Object parentElement = this.getParentElement(path);
        String propertyName = VABPathTools.getLastElement(path);
        try {
            Object childElement = this.handler.getElementProperty(parentElement, propertyName);
            this.handler.createValue(childElement, newValue);
        }
        catch (ResourceNotFoundException e) {
            this.handler.setModelPropertyValue(parentElement, propertyName, newValue);
        }
    }

    @Override
    public void deleteValue(String path) {
        VABPathTools.checkPathForNull(path);
        Object parentElement = this.getParentElement(path);
        String propertyName = VABPathTools.getLastElement(path);
        this.handler.deleteValue(parentElement, propertyName);
    }

    @Override
    public void deleteValue(String path, Object obj) {
        Object targetElement = this.getTargetElement(path);
        this.handler.deleteValue(targetElement, obj);
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) {
        Object childElement = this.getValue(path = VABPathTools.stripInvokeFromPath(path));
        if (childElement instanceof Function) {
            return this.runFunction(childElement, parameters);
        }
        if (childElement instanceof Supplier) {
            return this.runSupplier(childElement);
        }
        if (childElement instanceof Consumer) {
            return this.runConsumer(childElement, parameters);
        }
        if (childElement instanceof Runnable) {
            return this.runRunnable(childElement);
        }
        throw new NotAnInvokableException("Element \"" + path + "\" is not a function.");
    }

    private Object runRunnable(Object childElement) {
        Runnable runnable = (Runnable)childElement;
        try {
            runnable.run();
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return null;
    }

    private Object runConsumer(Object childElement, Object ... parameters) {
        Consumer consumer = (Consumer)childElement;
        try {
            consumer.accept(parameters);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return null;
    }

    private Object runSupplier(Object childElement) {
        Supplier supplier = (Supplier)childElement;
        try {
            return supplier.get();
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    private Object runFunction(Object childElement, Object ... parameters) {
        Function function = (Function)childElement;
        try {
            return function.apply(parameters);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    private Object getParentElement(String path) {
        VABPathTools.checkPathForNull(path);
        String[] pathElements = VABPathTools.splitPath(path);
        Object currentElement = this.elements;
        for (int i = 0; i < pathElements.length - 1; ++i) {
            currentElement = this.handler.getElementProperty(currentElement, pathElements[i]);
        }
        if (currentElement == null) {
            throw new ResourceNotFoundException("Parent element for \"" + path + "\" does not exist.");
        }
        return currentElement;
    }

    protected Object getTargetElement(String path) {
        VABPathTools.checkPathForNull(path);
        if (VABPathTools.isEmptyPath(path)) {
            return this.elements;
        }
        Object parentElement = this.getParentElement(path);
        String operationName = VABPathTools.getLastElement(path);
        if (operationName != null) {
            return this.handler.getElementProperty(parentElement, operationName);
        }
        return null;
    }
}

