/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;

public abstract class BasysHTTPServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> servletParameter = new LinkedHashMap<String, String>();
    protected String corsOrigin;
    protected GSONTools serializer = new GSONTools(new DefaultTypeFactory());

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.addCORSHeaderIfConfigured(response);
        if (request.getMethod().equalsIgnoreCase("PATCH")) {
            this.doPatch(request, response);
        } else {
            super.service(request, response);
        }
    }

    private void addCORSHeaderIfConfigured(HttpServletResponse response) {
        if (!this.isCorsOriginDefined()) {
            return;
        }
        this.addCorsHeaderToResponse(response);
    }

    private boolean isCorsOriginDefined() {
        return this.getCorsOrigin() != null;
    }

    private void addCorsHeaderToResponse(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", this.getCorsOrigin());
        response.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, PATCH");
        response.addHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type");
    }

    protected abstract void doPatch(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public BasysHTTPServlet withParameter(String parameter, String value) {
        this.servletParameter.put(parameter, value);
        return this;
    }

    public String getInitParameter(String name) {
        if (this.servletParameter.containsKey(name)) {
            return this.servletParameter.get(name);
        }
        return super.getInitParameter(name);
    }

    protected void sendResponse(Object value, PrintWriter outputStream) {
        outputStream.write(this.serializer.serialize(value));
        outputStream.flush();
    }

    public String getCorsOrigin() {
        return this.corsOrigin;
    }

    public void setCorsOrigin(String corsOrigin) {
        this.corsOrigin = corsOrigin;
    }
}

