/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.connector;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.opcua.connector.IOpcUaClient;
import org.eclipse.basyx.vab.protocol.opcua.exception.OpcUaException;
import org.eclipse.basyx.vab.protocol.opcua.types.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaConnector
implements IModelProvider {
    private static final Timer cacheTimer = new Timer(true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Duration cacheDuration = Duration.ZERO;
    private IOpcUaClient client;
    private Map<String, NodeId> nodeIdCache = new ConcurrentHashMap<String, NodeId>();
    private Map<String, List<NodeId>> operationNodeIdsCache = new ConcurrentHashMap<String, List<NodeId>>();

    public OpcUaConnector(String endpointUrl) {
        this.client = IOpcUaClient.create(endpointUrl);
    }

    public IOpcUaClient getClient() {
        return this.client;
    }

    public void setNodeIdCacheDuration(Duration cacheDuration) {
        if (cacheDuration == null || cacheDuration.isNegative()) {
            throw new IllegalArgumentException("cacheDuration must not be negative.");
        }
        this.cacheDuration = cacheDuration;
    }

    @Override
    public Object getValue(String path) throws OpcUaException {
        try {
            NodeId nodeId = this.getNodeIdForBrowsePath(path);
            return this.client.readValue(nodeId);
        }
        catch (OpcUaException e) {
            this.logger.error("Failed to get node value.");
            throw e;
        }
    }

    @Override
    public void setValue(String path, Object newValue) throws OpcUaException {
        try {
            NodeId nodeId = this.getNodeIdForBrowsePath(path);
            this.client.writeValue(nodeId, newValue);
        }
        catch (OpcUaException e) {
            this.logger.error("Failed to set node value.");
            throw e;
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new UnsupportedOperationException("Cannot create values through OPC UA.");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        throw new UnsupportedOperationException("Cannot delete values through OPC UA.");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new UnsupportedOperationException("Cannot delete values through OPC UA.");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws OpcUaException {
        try {
            List<NodeId> nodeIds = this.getNodeIdsForOperationBrowsePath(path);
            return this.client.invokeMethod(nodeIds.get(1), nodeIds.get(0), parameters);
        }
        catch (OpcUaException e) {
            this.logger.error("Failed to invoke operation.");
            throw e;
        }
    }

    private NodeId getNodeIdForBrowsePath(String browsePath) {
        if (this.nodeIdCache.containsKey(browsePath)) {
            this.logger.debug("Using cached NodeId for browse path '{}'.", (Object)browsePath);
            return this.nodeIdCache.get(browsePath);
        }
        NodeId nodeId = this.client.translateBrowsePathToNodeId(browsePath);
        if (!this.cacheDuration.isZero()) {
            this.nodeIdCache.put(browsePath, nodeId);
            cacheTimer.schedule(new RemoveEntryFromMapTimerTask<String, NodeId>(this.nodeIdCache, browsePath), this.cacheDuration.toMillis());
        }
        return nodeId;
    }

    private List<NodeId> getNodeIdsForOperationBrowsePath(String browsePath) {
        if (this.operationNodeIdsCache.containsKey(browsePath)) {
            this.logger.debug("Using cached NodeIds for operation at browse path '{}'.", (Object)browsePath);
            return this.operationNodeIdsCache.get(browsePath);
        }
        List<NodeId> nodeIds = this.client.translateBrowsePathToParentAndTargetNodeId(browsePath);
        if (!this.cacheDuration.isZero()) {
            this.operationNodeIdsCache.put(browsePath, nodeIds);
            cacheTimer.schedule(new RemoveEntryFromMapTimerTask<String, List<NodeId>>(this.operationNodeIdsCache, browsePath), this.cacheDuration.toMillis());
        }
        return nodeIds;
    }

    private static class RemoveEntryFromMapTimerTask<TKey, TValue>
    extends TimerTask {
        Map<TKey, TValue> map;
        TKey key;

        public RemoveEntryFromMapTimerTask(Map<TKey, TValue> map, TKey key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public void run() {
            this.map.remove(this.key);
        }
    }
}

