/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleHelper;
import org.eclipse.basyx.aas.factory.aasx.AASXToMetamodelConverter;
import org.eclipse.basyx.aas.factory.aasx.FileLoaderHelper;
import org.eclipse.basyx.aas.factory.aasx.SubmodelFileEndpointLoader;
import org.eclipse.basyx.aas.factory.json.JSONAASBundleFactory;
import org.eclipse.basyx.aas.factory.xml.XMLAASBundleFactory;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerFeature;
import org.eclipse.basyx.components.aas.aascomponent.InMemoryAASServerComponentFactory;
import org.eclipse.basyx.components.aas.aascomponent.MongoDBAASServerComponentFactory;
import org.eclipse.basyx.components.aas.authorization.AuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedAASServerFeatureFactory;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServlet;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServletParams;
import org.eclipse.basyx.components.aas.autoregistration.AutoRegisterAASServerFeature;
import org.eclipse.basyx.components.aas.configuration.AASEventBackend;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.components.aas.delegation.DelegationAASServerFeature;
import org.eclipse.basyx.components.aas.fileadaptation.FileValueAdaptingAASServerFeature;
import org.eclipse.basyx.components.aas.mqtt.MqttAASServerFeature;
import org.eclipse.basyx.components.aas.mqtt.MqttV2AASServerFeature;
import org.eclipse.basyx.components.aas.servlet.AASAggregatorAASXUploadServlet;
import org.eclipse.basyx.components.aas.servlet.AASAggregatorServlet;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.extensions.aas.aggregator.aasxupload.AASAggregatorAASXUpload;
import org.eclipse.basyx.extensions.aas.aggregator.aasxupload.api.IAASAggregatorAASXUpload;
import org.eclipse.basyx.extensions.aas.registration.authorization.AuthorizedAASRegistryProxy;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.encoding.Base64URLEncoder;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.basyx.extensions.shared.encoding.URLEncoder;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxChildContext;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AASServerComponent
implements IComponent {
    private static Logger logger = LoggerFactory.getLogger(AASServerComponent.class);
    private BaSyxHTTPServer server;
    private IAASRegistry registry;
    private BaSyxContextConfiguration contextConfig;
    private BaSyxAASServerConfiguration aasConfig;
    private BaSyxMongoDBConfiguration mongoDBConfig;
    private BaSyxSecurityConfiguration securityConfig;
    private List<IAASServerFeature> aasServerFeatureList = new ArrayList<IAASServerFeature>();
    protected List<Collection<AASBundle>> aasBundles = new ArrayList<Collection<AASBundle>>();
    private IAASAggregator aggregator;
    private boolean isAASXUploadEnabled = false;
    private static final String PREFIX_SUBMODEL_PATH = "/aas/submodels/";
    private static final String AASX_RES_FILE_CONTEXT_PATH = "basyx-temp";
    private static final String AASX_RES_FILE_DOCBASE_PATH = VABPathTools.append((String)System.getProperty("java.io.tmpdir"), (String)"basyx-temp");
    private static final String AASX_RES_FILE_SERVLET_MAPPING_PATTERN = "/*";

    public AASServerComponent(BaSyxContextConfiguration contextConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = new BaSyxAASServerConfiguration();
    }

    public AASServerComponent(BaSyxContextConfiguration contextConfig, BaSyxAASServerConfiguration aasConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = aasConfig;
    }

    public AASServerComponent(BaSyxContextConfiguration contextConfig, BaSyxAASServerConfiguration aasConfig, BaSyxMongoDBConfiguration mongoDBConfig) {
        this.contextConfig = contextConfig;
        this.aasConfig = aasConfig;
        this.aasConfig.setAASBackend(AASServerBackend.MONGODB);
        this.mongoDBConfig = mongoDBConfig;
    }

    @Deprecated
    public void enableMQTT(BaSyxMqttConfiguration configuration) {
        this.aasServerFeatureList.add(new MqttAASServerFeature(configuration, this.getMqttSubmodelClientId()));
    }

    @Deprecated
    public void disableMQTT() {
        this.aasServerFeatureList.forEach(f -> {
            if (f instanceof MqttAASServerFeature) {
                this.aasServerFeatureList.remove(f);
            }
        });
    }

    public void enableAASXUpload() {
        this.isAASXUploadEnabled = true;
    }

    public void setRegistry(IAASRegistry registry) {
        this.registry = registry;
    }

    public void setAASBundles(Collection<AASBundle> aasBundles) {
        this.aasBundles = new ArrayList<Collection<AASBundle>>();
        this.aasBundles.add(aasBundles);
    }

    public void setAASBundle(AASBundle aasBundle) {
        this.aasBundles = new ArrayList<Collection<AASBundle>>();
        Set<AASBundle> firstBundleSet = Collections.singleton(aasBundle);
        this.aasBundles.add(firstBundleSet);
    }

    public void setSecurityConfiguration(BaSyxSecurityConfiguration configuration) {
        this.securityConfig = configuration;
    }

    public void startComponent() {
        logger.info("Create the server...");
        this.registry = this.createRegistryFromConfig(this.aasConfig);
        this.loadAASServerFeaturesFromConfig();
        this.initializeAASServerFeatures();
        BaSyxContext context = this.contextConfig.createBaSyxContext();
        this.initializeAasBundles(context);
        context.addServletMapping(AASX_RES_FILE_SERVLET_MAPPING_PATTERN, this.createAggregatorServlet());
        this.addAASServerFeaturesToContext(context);
        logger.info("Start the server");
        this.server = new BaSyxHTTPServer(context);
        this.server.start();
        this.registerPreexistingAASAndSMIfPossible();
    }

    private String getRootFilePathWithContext(String contextPath) {
        return VABPathTools.append((String)contextPath, (String)AASX_RES_FILE_CONTEXT_PATH);
    }

    private DefaultServlet createDefaultServlet() {
        AuthorizedDefaultServletParams<?> params;
        if (this.aasConfig.isAuthorizationEnabled() && (params = this.getAuthorizedDefaultServletParams()) != null) {
            return new AuthorizedDefaultServlet(params);
        }
        return new DefaultServlet();
    }

    private AuthorizedDefaultServletParams<?> getAuthorizedDefaultServletParams() {
        AuthorizedAASServerFeature<?> authorizedAASServerFeature = new AuthorizedAASServerFeatureFactory(this.securityConfig).create();
        return authorizedAASServerFeature.getFilesAuthorizerParams();
    }

    private void registerPreexistingAASAndSMIfPossible() {
        if (!this.shouldRegisterPreexistingAASAndSM()) {
            return;
        }
        this.aggregator.getAASList().stream().forEach(this::registerAASAndSubmodels);
    }

    private boolean shouldRegisterPreexistingAASAndSM() {
        return this.isMongoDBBackend() && this.registry != null;
    }

    private void registerAASAndSubmodels(IAssetAdministrationShell aas) {
        this.registerAAS(aas);
        this.registerSubmodels(aas);
    }

    private void registerAAS(IAssetAdministrationShell aas) {
        try {
            String combinedEndpoint = this.getAASAccessPath(aas);
            this.registry.register(new AASDescriptor(aas, combinedEndpoint));
            logger.info("The AAS " + aas.getIdShort() + " is Successfully Registered from DB");
        }
        catch (Exception e) {
            logger.info("The AAS " + aas.getIdShort() + " could not be Registered from DB" + e);
        }
    }

    private String getAASAccessPath(IAssetAdministrationShell aas) {
        return VABPathTools.concatenatePaths((String[])new String[]{this.getURL(), AASAggregatorAPIHelper.getAASAccessPath((IIdentifier)aas.getIdentification())});
    }

    private void registerSubmodels(IAssetAdministrationShell aas) {
        List<ISubmodel> submodels = this.getSubmodelFromAggregator(this.aggregator, aas.getIdentification());
        try {
            submodels.stream().forEach(submodel -> this.registerSubmodel(aas, (ISubmodel)submodel));
            logger.info("The submodels from AAS " + aas.getIdShort() + " are Successfully Registered from DB");
        }
        catch (Exception e) {
            logger.info("The submodel from AAS " + aas.getIdShort() + " could not be Registered from DB " + e);
        }
    }

    private void registerSubmodel(IAssetAdministrationShell aas, ISubmodel submodel) {
        String smEndpoint = VABPathTools.concatenatePaths((String[])new String[]{this.getAASAccessPath(aas), "submodels", submodel.getIdShort(), "submodel"});
        this.registry.register(aas.getIdentification(), new SubmodelDescriptor(submodel, smEndpoint));
    }

    private List<ISubmodel> getSubmodelFromAggregator(IAASAggregator aggregator, IIdentifier iIdentifier) {
        MultiSubmodelProvider aasProvider = (MultiSubmodelProvider)aggregator.getAASProvider(iIdentifier);
        List submodelObject = (List)aasProvider.getValue(PREFIX_SUBMODEL_PATH);
        ArrayList<ISubmodel> persistentSubmodelList = new ArrayList<ISubmodel>();
        submodelObject.stream().map(this::getSubmodel).forEach(persistentSubmodelList::add);
        return persistentSubmodelList;
    }

    private ISubmodel getSubmodel(Object submodelObject) {
        return Submodel.createAsFacade((Map)((Map)submodelObject));
    }

    private void loadAASServerFeaturesFromConfig() {
        if (this.aasConfig.isPropertyDelegationEnabled()) {
            this.addAASServerFeature(new DelegationAASServerFeature());
        }
        if (this.isAutoRegisterEnabled()) {
            this.addAASServerFeature(new AutoRegisterAASServerFeature(this.registry, this.getURL()));
        }
        if (this.isEventingEnabled()) {
            this.configureMqttFeature();
        }
        this.configureSecurity();
        this.addAASServerFeature(new FileValueAdaptingAASServerFeature(this.getURL()));
        if (this.aasConfig.isAASXUploadEnabled()) {
            this.enableAASXUpload();
        }
    }

    private boolean isAutoRegisterEnabled() {
        return this.isRegistryConfigured() && !this.isSubmodelRegistrationWhiteListConfigured();
    }

    private boolean isSubmodelRegistrationWhiteListConfigured() {
        return !this.aasConfig.getSubmodels().isEmpty();
    }

    private void configureSecurity() {
        if (!this.aasConfig.isAuthorizationEnabled()) {
            return;
        }
        if (this.securityConfig == null) {
            this.securityConfig = new BaSyxSecurityConfiguration();
            this.securityConfig.loadFromDefaultSource();
        }
        this.addAASServerFeature(new AuthorizedAASServerFeatureFactory(this.securityConfig).create());
    }

    private boolean isRegistryConfigured() {
        if (this.registry != null) {
            return true;
        }
        String registryUrl = this.aasConfig.getRegistry();
        return registryUrl != null && !registryUrl.isEmpty();
    }

    private boolean isEventingEnabled() {
        return !this.aasConfig.getAASEvents().equals((Object)AASEventBackend.NONE);
    }

    private void configureMqttFeature() {
        BaSyxMqttConfiguration mqttConfig = new BaSyxMqttConfiguration();
        mqttConfig.loadFromDefaultSource();
        if (this.aasConfig.getAASEvents().equals((Object)AASEventBackend.MQTT)) {
            this.addAASServerFeature(new MqttAASServerFeature(mqttConfig, mqttConfig.getClientId()));
        } else if (this.aasConfig.getAASEvents().equals((Object)AASEventBackend.MQTTV2)) {
            this.addAASServerFeature(new MqttV2AASServerFeature(mqttConfig, mqttConfig.getClientId(), this.aasConfig.getAASId(), (IEncoder)new Base64URLEncoder()));
        } else if (this.aasConfig.getAASEvents().equals((Object)AASEventBackend.MQTTV2_SIMPLE_ENCODING)) {
            this.addAASServerFeature(new MqttV2AASServerFeature(mqttConfig, mqttConfig.getClientId(), this.aasConfig.getAASId(), (IEncoder)new URLEncoder()));
        }
    }

    public String getURL() {
        if (this.isExternalPathConfigured()) {
            return this.getExternalURL();
        }
        return this.getInternalURL();
    }

    private boolean isExternalPathConfigured() {
        String hostPath = this.aasConfig.getHostpath();
        return hostPath != null && !hostPath.isEmpty();
    }

    private String getExternalURL() {
        return this.aasConfig.getHostpath();
    }

    private String getInternalURL() {
        String basePath = this.aasConfig.getHostpath();
        if (basePath.isEmpty()) {
            return this.contextConfig.getUrl();
        }
        return basePath;
    }

    public void stopComponent() {
        this.deregisterAASAndSmAddedDuringRuntime();
        this.cleanUpAASServerFeatures();
        this.server.shutdown();
        logger.info("AAS Server stopped");
    }

    private void deregisterAASAndSmAddedDuringRuntime() {
        if (this.registry == null) {
            return;
        }
        try {
            this.aggregator.getAASList().stream().forEach(this::deregisterAASAndAccompanyingSM);
        }
        catch (RuntimeException e) {
            logger.info("The resource could not be found in the aggregator " + e);
        }
    }

    private void deregisterAASAndAccompanyingSM(IAssetAdministrationShell aas) {
        this.getSubmodelDescriptors(aas.getIdentification()).stream().forEach(submodelDescriptor -> this.deregisterSubmodel(aas.getIdentification(), (SubmodelDescriptor)submodelDescriptor));
        this.deregisterAAS(aas.getIdentification());
    }

    private List<SubmodelDescriptor> getSubmodelDescriptors(IIdentifier aasIdentifier) {
        try {
            return this.registry.lookupSubmodels(aasIdentifier);
        }
        catch (ResourceNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private void deregisterSubmodel(IIdentifier aasIdentifier, SubmodelDescriptor submodelDescriptor) {
        try {
            this.registry.delete(aasIdentifier, submodelDescriptor.getIdentifier());
            logger.info("The SM '" + submodelDescriptor.getIdShort() + "' successfully deregistered.");
        }
        catch (ProviderException e) {
            logger.info("The SM '" + submodelDescriptor.getIdShort() + "' can't be deregistered. It was not found in registry.");
        }
    }

    private void deregisterAAS(IIdentifier aasIdentifier) {
        try {
            this.registry.delete(aasIdentifier);
            logger.info("The AAS '" + aasIdentifier.getId() + "' successfully deregistered.");
        }
        catch (ProviderException e) {
            logger.info("The AAS '" + aasIdentifier.getId() + "' can't be deregistered. It was not found in registry.");
        }
    }

    public void addAASServerFeature(IAASServerFeature aasServerFeature) {
        this.aasServerFeatureList.add(aasServerFeature);
    }

    private void initializeAASServerFeatures() {
        for (IAASServerFeature aasServerFeature : this.aasServerFeatureList) {
            aasServerFeature.initialize();
        }
    }

    private void initializeAasBundles(BaSyxContext context) {
        this.loadAASBundles();
        if (this.aasBundles == null) {
            return;
        }
        logger.info("Initializing AAS Bundles");
        this.createBasyxResourceDirectoryIfNotExists();
        this.addAasxFilesResourceServlet(context);
        this.modifyFilePaths(this.contextConfig.getHostname(), this.contextConfig.getPort(), this.getRootFilePathWithContext(this.contextConfig.getContextPath()));
        this.registerWhitelistedSubmodels();
    }

    private void cleanUpAASServerFeatures() {
        for (IAASServerFeature aasServerFeature : this.aasServerFeatureList) {
            aasServerFeature.cleanUp();
        }
    }

    private String loadBundleString(String filePath) throws IOException {
        String content;
        try {
            content = IOUtils.toString((InputStream)FileLoaderHelper.getInputStream((String)filePath), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            logger.info("Could not find a corresponding file. Loading from default resource.");
            content = BaSyxConfiguration.getResourceString((String)filePath);
        }
        return content;
    }

    private Set<AASBundle> loadBundleFromXML(String xmlPath) throws IOException, ParserConfigurationException, SAXException {
        logger.info("Loading aas from xml \"" + xmlPath + "\"");
        String xmlContent = this.loadBundleString(xmlPath);
        return new XMLAASBundleFactory(xmlContent).create();
    }

    private Set<AASBundle> loadBundleFromJSON(String jsonPath) throws IOException {
        logger.info("Loading aas from json \"" + jsonPath + "\"");
        String jsonContent = this.loadBundleString(jsonPath);
        return new JSONAASBundleFactory(jsonContent).create();
    }

    private static Set<AASBundle> loadBundleFromAASX(String aasxPath, String childFilePath) throws IOException, ParserConfigurationException, SAXException, InvalidFormatException, URISyntaxException {
        logger.info("Loading aas from aasx \"" + aasxPath + "\"");
        try (AASXToMetamodelConverter packageManager = new AASXToMetamodelConverter(aasxPath);){
            packageManager.unzipRelatedFilesToChildPath(childFilePath);
            Set set = packageManager.retrieveAASBundles();
            return set;
        }
    }

    private void addAASServerFeaturesToContext(BaSyxContext context) {
        for (IAASServerFeature aasServerFeature : this.aasServerFeatureList) {
            aasServerFeature.addToContext(context);
        }
    }

    private Collection<AASBundle> getFlatAASBundles() {
        ArrayList<AASBundle> result = new ArrayList<AASBundle>();
        for (Collection<AASBundle> bundle : this.aasBundles) {
            result.addAll(bundle);
        }
        return result;
    }

    private VABHTTPInterface<?> createAggregatorServlet() {
        this.aggregator = this.createAASAggregator();
        if (this.aasBundles != null) {
            try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
                AASBundleHelper.integrate((IAASAggregator)this.aggregator, this.getFlatAASBundles());
            }
        }
        if (this.isAASXUploadEnabled) {
            return new AASAggregatorAASXUploadServlet((IAASAggregatorAASXUpload)new AASAggregatorAASXUpload(this.aggregator));
        }
        return new AASAggregatorServlet(this.aggregator);
    }

    private IAASAggregator createAASAggregator() {
        if (this.isMongoDBBackend()) {
            try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
                IAASAggregator iAASAggregator = new MongoDBAASServerComponentFactory(this.createMongoDbConfiguration(), this.createAASServerDecoratorList(), this.registry).create();
                return iAASAggregator;
            }
        }
        return new InMemoryAASServerComponentFactory(this.createAASServerDecoratorList(), this.registry).create();
    }

    private boolean isMongoDBBackend() {
        return this.aasConfig.getAASBackend().equals((Object)AASServerBackend.MONGODB);
    }

    private BaSyxMongoDBConfiguration createMongoDbConfiguration() {
        BaSyxMongoDBConfiguration config;
        if (this.mongoDBConfig == null) {
            config = new BaSyxMongoDBConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.mongoDBConfig;
        }
        return config;
    }

    private List<IAASServerDecorator> createAASServerDecoratorList() {
        ArrayList<IAASServerDecorator> aasServerDecoratorList = new ArrayList<IAASServerDecorator>();
        for (IAASServerFeature aasServerFeature : this.aasServerFeatureList) {
            aasServerDecoratorList.add(aasServerFeature.getDecorator());
        }
        return aasServerDecoratorList;
    }

    private void loadAASBundles() {
        if (!this.aasBundles.isEmpty()) {
            return;
        }
        List<String> aasSources = this.aasConfig.getAASSourceAsList();
        this.aasBundles = this.loadAASFromSource(aasSources);
    }

    private List<Collection<AASBundle>> loadAASFromSource(List<String> aasSources) {
        if (aasSources.isEmpty()) {
            return new ArrayList<Collection<AASBundle>>();
        }
        ArrayList<Collection<AASBundle>> aasBundlesSet = new ArrayList<Collection<AASBundle>>();
        for (int i = 0; i < aasSources.size(); ++i) {
            String aasSource = aasSources.get(i);
            String subFilePath = this.getAASXFileSubPath(i);
            Set<AASBundle> loadedBundles = this.loadBundleFromFile(aasSource, subFilePath);
            aasBundlesSet.add(loadedBundles);
        }
        return aasBundlesSet;
    }

    private String getAASXFileSubPath(int aasxIndex) {
        return "aasx" + Integer.toString(aasxIndex);
    }

    private Set<AASBundle> loadBundleFromFile(String aasSource, String childFilePath) {
        try {
            if (aasSource.endsWith(".aasx")) {
                return AASServerComponent.loadBundleFromAASX(aasSource, childFilePath);
            }
            if (aasSource.endsWith(".json")) {
                return this.loadBundleFromJSON(aasSource);
            }
            if (aasSource.endsWith(".xml")) {
                return this.loadBundleFromXML(aasSource);
            }
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | InvalidFormatException | SAXException e) {
            logger.error("Could not load initial AAS from source '" + aasSource + "'");
        }
        return Collections.emptySet();
    }

    private IAASRegistry createRegistryFromConfig(BaSyxAASServerConfiguration aasConfig) {
        if (this.registry != null) {
            return this.registry;
        }
        String registryUrl = aasConfig.getRegistry();
        if (registryUrl == null || registryUrl.isEmpty()) {
            return null;
        }
        logger.info("Registry loaded at \"" + registryUrl + "\"");
        if (this.shouldUseSecuredRegistryConnection(aasConfig)) {
            return new AuthorizedAASRegistryProxy(registryUrl, aasConfig.configureAndGetAuthorizationSupplier());
        }
        return new AASRegistryProxy(registryUrl);
    }

    private boolean shouldUseSecuredRegistryConnection(BaSyxAASServerConfiguration aasConfig) {
        return aasConfig.isAuthorizationCredentialsForSecuredRegistryConfigured();
    }

    private void registerWhitelistedSubmodels() {
        if (!this.aasConfig.getSubmodels().isEmpty()) {
            this.registerSubmodelsFromWhitelist();
        }
    }

    private void registerSubmodelsFromWhitelist() {
        logger.info("Register from whitelist");
        List descriptors = this.registry.lookupAll();
        List<String> smWhitelist = this.aasConfig.getSubmodels();
        for (String s : smWhitelist) {
            this.updateSMEndpoint(s, descriptors);
        }
    }

    private void updateSMEndpoint(String smId, List<AASDescriptor> descriptors) {
        descriptors.forEach(desc -> {
            Collection smDescriptors = desc.getSubmodelDescriptors();
            SubmodelDescriptor smDescriptor = this.findSMDescriptor(smId, smDescriptors);
            this.updateSMEndpoint(smDescriptor);
            this.registry.register(desc.getIdentifier(), smDescriptor);
        });
    }

    private void updateSMEndpoint(SubmodelDescriptor smDescriptor) {
        String smEndpoint = this.getSMEndpoint(smDescriptor.getIdentifier());
        String firstEndpoint = smDescriptor.getFirstEndpoint();
        if (firstEndpoint.isEmpty()) {
            smDescriptor.removeEndpoint("");
        } else if (firstEndpoint.equals("/submodel")) {
            smDescriptor.removeEndpoint("/submodel");
        }
        smDescriptor.addEndpoint(smEndpoint);
    }

    private SubmodelDescriptor findSMDescriptor(String smId, Collection<SubmodelDescriptor> smDescriptors) {
        for (SubmodelDescriptor smDesc : smDescriptors) {
            if (!smDesc.getIdentifier().getId().equals(smId)) continue;
            return smDesc;
        }
        return null;
    }

    private String getSMEndpoint(IIdentifier smId) {
        String aasId = this.getAASIdFromSMId(smId);
        String encodedAASId = VABPathTools.encodePathElement((String)aasId);
        String aasBasePath = VABPathTools.concatenatePaths((String[])new String[]{this.getURL(), encodedAASId, "aas"});
        String smIdShort = this.getSMIdShortFromSMId(smId);
        return VABPathTools.concatenatePaths((String[])new String[]{aasBasePath, "submodels", smIdShort, "submodel"});
    }

    private String getSMIdShortFromSMId(IIdentifier smId) {
        Collection<AASBundle> flatAasBundles = this.getFlatAASBundles();
        for (AASBundle bundle : flatAasBundles) {
            for (ISubmodel sm : bundle.getSubmodels()) {
                if (!smId.getId().equals(sm.getIdentification().getId())) continue;
                return sm.getIdShort();
            }
        }
        throw new ResourceNotFoundException("Submodel in registry whitelist not found in AASBundle");
    }

    private String getAASIdFromSMId(IIdentifier smId) {
        Collection<AASBundle> flatAasBundles = this.getFlatAASBundles();
        for (AASBundle bundle : flatAasBundles) {
            for (ISubmodel sm : bundle.getSubmodels()) {
                if (!smId.getId().equals(sm.getIdentification().getId())) continue;
                return bundle.getAAS().getIdentification().getId();
            }
        }
        throw new ResourceNotFoundException("Submodel in registry whitelist does not belong to any AAS in AASBundle");
    }

    private void modifyFilePaths(String hostName, int port, String rootPath) {
        for (int i = 0; i < this.aasBundles.size(); ++i) {
            Collection<AASBundle> bundleSet = this.aasBundles.get(i);
            String bundleFileRootPath = VABPathTools.concatenatePaths((String[])new String[]{rootPath, this.getAASXFileSubPath(i), "files"});
            this.modifyFilePathsInBundleSet(bundleSet, hostName, port, bundleFileRootPath);
        }
    }

    private void modifyFilePathsInBundleSet(Collection<AASBundle> bundleSet, String hostName, int port, String bundleFileRootPath) {
        for (AASBundle bundle : bundleSet) {
            Set submodels = bundle.getSubmodels();
            for (ISubmodel sm : submodels) {
                SubmodelFileEndpointLoader.setRelativeFileEndpoints((ISubmodel)sm, (String)hostName, (int)port, (String)bundleFileRootPath);
            }
        }
    }

    private String getMqttAASClientId() {
        if (this.aasBundles == null || this.aasBundles.isEmpty()) {
            return "defaultNoShellId";
        }
        Collection<AASBundle> firstBundleSet = this.aasBundles.get(0);
        if (firstBundleSet == null || firstBundleSet.isEmpty()) {
            return "defaultNoShellId";
        }
        return firstBundleSet.stream().findFirst().get().getAAS().getIdShort();
    }

    private String getMqttSubmodelClientId() {
        return this.getMqttAASClientId() + "/submodelAggregator";
    }

    private void addAasxFilesResourceServlet(BaSyxContext context) {
        DefaultServlet httpServlet = this.createDefaultServlet();
        String childContextPath = VABPathTools.append((String)this.contextConfig.getContextPath(), (String)AASX_RES_FILE_CONTEXT_PATH);
        Context childContext = this.createChildContextForAasxResourceFiles(childContextPath, AASX_RES_FILE_DOCBASE_PATH);
        context.addChildContext(new BaSyxChildContext(childContext, (HttpServlet)httpServlet, AASX_RES_FILE_SERVLET_MAPPING_PATTERN));
    }

    private Context createChildContextForAasxResourceFiles(String childContextPath, String childDocbasePath) {
        StandardContext childContext = new StandardContext();
        childContext.setPath(childContextPath);
        childContext.setDocBase(childDocbasePath);
        childContext.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        return childContext;
    }

    private void createBasyxResourceDirectoryIfNotExists() {
        File directory = new File(AASX_RES_FILE_DOCBASE_PATH);
        if (directory.exists()) {
            return;
        }
        directory.mkdir();
    }
}

