/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.authorization.internal;

import java.util.Arrays;
import org.eclipse.basyx.components.aas.authorization.AuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.CustomAuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.GrantedAuthorityAuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.SimpleRbacAuthorizedAASServerFeature;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;

public class AuthorizedAASServerFeatureFactory {
    private BaSyxSecurityConfiguration securityConfig;

    public AuthorizedAASServerFeatureFactory(BaSyxSecurityConfiguration securityConfig) {
        this.securityConfig = securityConfig;
    }

    public AuthorizedAASServerFeature<?> create() {
        BaSyxSecurityConfiguration.AuthorizationStrategy strategy;
        String strategyString = this.securityConfig.getAuthorizationStrategy();
        if (strategyString == null) {
            throw new IllegalArgumentException(String.format("no authorization strategy set, please set %s in security.properties", "authorization.strategy"));
        }
        try {
            strategy = BaSyxSecurityConfiguration.AuthorizationStrategy.valueOf((String)strategyString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("unknown authorization strategy %s set in security.properties, available options: %s", strategyString, Arrays.toString(BaSyxSecurityConfiguration.AuthorizationStrategy.values())));
        }
        switch (strategy) {
            case SimpleRbac: {
                return new SimpleRbacAuthorizedAASServerFeature(this.securityConfig);
            }
            case GrantedAuthority: {
                return new GrantedAuthorityAuthorizedAASServerFeature(this.securityConfig);
            }
            case Custom: {
                return new CustomAuthorizedAASServerFeature(this.securityConfig);
            }
        }
        throw new UnsupportedOperationException("no handler for authorization strategy " + strategyString);
    }
}

