/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.authorization.internal;

import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.AuthorizedAASServerFeature;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedAASServerDecorator;
import org.eclipse.basyx.components.aas.authorization.internal.AuthorizedDefaultServletParams;
import org.eclipse.basyx.components.aas.authorization.internal.Authorizers;
import org.eclipse.basyx.components.aas.authorization.internal.IAuthorizersProvider;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuthorizedAASServerFeature<SubjectInformationType>
extends AuthorizedAASServerFeature<SubjectInformationType> {
    private static Logger logger = LoggerFactory.getLogger(CustomAuthorizedAASServerFeature.class);

    public CustomAuthorizedAASServerFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public IAASServerDecorator getDecorator() {
        logger.info("use Custom authorization strategy");
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        IAuthorizersProvider<SubjectInformationType> authorizersProvider = this.getAuthorizersProvider();
        Authorizers<SubjectInformationType> authorizers = authorizersProvider.get(this.securityConfig);
        return new AuthorizedAASServerDecorator<SubjectInformationType>(authorizers.getSubmodelAPIAuthorizer(), authorizers.getSubmodelAggregatorAuthorizer(), authorizers.getAasApiAuthorizer(), authorizers.getAasAggregatorAuthorizer(), subjectInformationProvider);
    }

    @Override
    public AuthorizedDefaultServletParams<SubjectInformationType> getFilesAuthorizerParams() {
        logger.info("use Custom authorization strategy for files authorizer");
        IAuthorizersProvider<SubjectInformationType> authorizersProvider = this.getAuthorizersProvider();
        Authorizers<SubjectInformationType> authorizers = authorizersProvider.get(this.securityConfig);
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        return new AuthorizedDefaultServletParams<SubjectInformationType>(authorizers.getFilesAuthorizer(), subjectInformationProvider);
    }

    private IAuthorizersProvider<SubjectInformationType> getAuthorizersProvider() {
        return (IAuthorizersProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.custom.authorizersProvider", IAuthorizersProvider.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getSubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.custom.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

