/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.autoregistration;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.AASAggregatorAPIHelper;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AutoRegisterAASAggregator
implements IAASAggregator {
    private IAASAggregator aggregator;
    private IAASRegistry registry;
    private String endpoint;

    public AutoRegisterAASAggregator(IAASAggregator aggregator, IAASRegistry registry, String endpoint) {
        this.aggregator = aggregator;
        this.registry = registry;
        this.endpoint = endpoint;
    }

    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aggregator.getAASList();
    }

    public IAssetAdministrationShell getAAS(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aggregator.getAAS(aasId);
    }

    public IModelProvider getAASProvider(IIdentifier aasId) throws ResourceNotFoundException {
        return this.aggregator.getAASProvider(aasId);
    }

    public void createAAS(AssetAdministrationShell aas) {
        this.aggregator.createAAS(aas);
        this.registry.register(new AASDescriptor((IAssetAdministrationShell)aas, this.getEndpoint(aas)));
    }

    private String getEndpoint(AssetAdministrationShell aas) {
        String harmonized = AASAggregatorAPIHelper.harmonizeURL((String)this.endpoint);
        String aasAccessPath = AASAggregatorAPIHelper.getAASAccessPath((IIdentifier)aas.getIdentification());
        return VABPathTools.concatenatePaths((String[])new String[]{harmonized, aasAccessPath});
    }

    public void updateAAS(AssetAdministrationShell aas) throws ResourceNotFoundException {
        this.aggregator.updateAAS(aas);
    }

    public void deleteAAS(IIdentifier aasId) {
        this.aggregator.deleteAAS(aasId);
        this.registry.delete(aasId);
    }
}

