/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAPIFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAPI;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAPIFactory;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPI;
import org.eclipse.basyx.components.internal.mongodb.MongoDBBaSyxStorageAPIFactory;
import org.eclipse.basyx.extensions.internal.storage.BaSyxStorageAPI;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBAASAggregator
implements IAASAggregator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAASRegistry registry;
    protected IAASAPIFactory shellApiFactory;
    protected ISubmodelAPIFactory submodelApiFactory;
    @Deprecated
    protected ISubmodelAggregator submodelAggregator;
    protected ISubmodelAggregatorFactory submodelAggregatorFactory;
    private MongoDBBaSyxStorageAPI<Submodel> submodelStorageApi;
    private MongoDBBaSyxStorageAPI<AssetAdministrationShell> shellStorageApi;

    public MongoDBAASAggregator(IAASRegistry registry, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoDBBaSyxStorageAPI<Submodel> submodelStorageApi, MongoDBBaSyxStorageAPI<AssetAdministrationShell> shellStorageApi) {
        this.submodelStorageApi = submodelStorageApi;
        this.shellStorageApi = shellStorageApi;
        this.shellApiFactory = shellAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.registry = registry;
    }

    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this(registry, shellAPIFactory, submodelAggregatorFactory, MongoDBAASAggregator.submodelStorageApiFromConfig(config, client), MongoDBAASAggregator.shellStorageApiFromConfig(config, client));
    }

    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this(config, null, shellAPIFactory, submodelAggregatorFactory, client);
    }

    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath), registry, shellAPIFactory, submodelAggregatorFactory, client);
    }

    public MongoDBAASAggregator(String resourceConfigPath, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath), shellAPIFactory, submodelAggregatorFactory, client);
    }

    public MongoDBAASAggregator(IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this("mongodb.properties", shellAPIFactory, submodelAggregatorFactory, client);
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config) {
        this(config, null);
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath));
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath), registry);
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry) {
        this(registry, MongoDBAASAggregator.initShellApiFactory(config), MongoDBAASAggregator.initSubmodelAggregatorFactory(config), MongoDBAASAggregator.submodelStorageApiFromConfig(config, null), MongoDBAASAggregator.shellStorageApiFromConfig(config, null));
    }

    @Deprecated
    public MongoDBAASAggregator() {
        this("mongodb.properties");
    }

    @Deprecated
    public MongoDBAASAggregator(IAASRegistry registry) {
        this("mongodb.properties", registry);
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(config, registry, shellAPIFactory, submodelAggregatorFactory, MongoClients.create((String)config.getConnectionUrl()));
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(config, shellAPIFactory, submodelAggregatorFactory, MongoClients.create((String)config.getConnectionUrl()));
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath), registry, shellAPIFactory, submodelAggregatorFactory);
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(MongoDBAASAggregator.loadConfigFromPath(resourceConfigPath), shellAPIFactory, submodelAggregatorFactory);
    }

    @Deprecated
    public MongoDBAASAggregator(IAASAPIFactory shellAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this("mongodb.properties", shellAPIFactory, submodelAggregatorFactory);
    }

    private static ISubmodelAggregatorFactory initSubmodelAggregatorFactory(BaSyxMongoDBConfiguration config) {
        ISubmodelAPIFactory submodelApiFactory = MongoDBAASAggregator.initSubmodelApiFactory(config);
        return new SubmodelAggregatorFactory(submodelApiFactory);
    }

    private static ISubmodelAPIFactory initSubmodelApiFactory(BaSyxMongoDBConfiguration config) {
        return new MongoDBSubmodelAPIFactory(config);
    }

    private static IAASAPIFactory initShellApiFactory(BaSyxMongoDBConfiguration config) {
        return new MongoDBAASAPIFactory(config);
    }

    private static MongoDBBaSyxStorageAPI<Submodel> submodelStorageApiFromConfig(BaSyxMongoDBConfiguration config, MongoClient client) {
        String submodelCollectionName = config.getSubmodelCollection();
        MongoDBBaSyxStorageAPI submodelStorageApi = client == null ? MongoDBBaSyxStorageAPIFactory.create((String)submodelCollectionName, Submodel.class, (BaSyxMongoDBConfiguration)config) : MongoDBBaSyxStorageAPIFactory.create((String)submodelCollectionName, Submodel.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client);
        return submodelStorageApi;
    }

    private static MongoDBBaSyxStorageAPI<AssetAdministrationShell> shellStorageApiFromConfig(BaSyxMongoDBConfiguration config, MongoClient client) {
        String shellCollectionName = config.getAASCollection();
        MongoDBBaSyxStorageAPI shellStorageApi = client == null ? MongoDBBaSyxStorageAPIFactory.create((String)shellCollectionName, AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)config) : MongoDBBaSyxStorageAPIFactory.create((String)shellCollectionName, AssetAdministrationShell.class, (BaSyxMongoDBConfiguration)config, (MongoClient)client);
        return shellStorageApi;
    }

    private static BaSyxMongoDBConfiguration loadConfigFromPath(String resourceConfigPath) {
        BaSyxMongoDBConfiguration config = new BaSyxMongoDBConfiguration();
        config.loadFromResource(resourceConfigPath);
        return config;
    }

    @Deprecated
    public void setRegistry(IAASRegistry registry) {
        this.registry = registry;
    }

    public void reset() {
        Collection shells = this.shellStorageApi.retrieveAll();
        Collection submodels = this.submodelStorageApi.retrieveAll();
        shells.forEach(shell -> this.shellStorageApi.delete(shell.getIdentification().getId()));
        submodels.forEach(shell -> this.submodelStorageApi.delete(shell.getIdentification().getId()));
    }

    private MultiSubmodelProvider createMultiSubmodelProvider(IAASAPI shellApi) {
        AASModelProvider contentProvider = this.createContentProvider(shellApi);
        HTTPConnectorFactory connectorFactory = new HTTPConnectorFactory();
        ISubmodelAggregator submodelAggregator = this.getSubmodelAggregatorInstance(shellApi.getAAS().getIdentification());
        return new MultiSubmodelProvider(contentProvider, this.registry, (IConnectorFactory)connectorFactory, this.shellApiFactory, submodelAggregator);
    }

    private AASModelProvider createContentProvider(IAASAPI shellApi) {
        return new AASModelProvider(shellApi);
    }

    private ISubmodelAggregator getSubmodelAggregatorInstance(IIdentifier shellId) {
        if (this.submodelAggregatorFactory == null) {
            return this.submodelAggregator;
        }
        return this.submodelAggregatorFactory.create(shellId);
    }

    private void addSubmodelsFromDB(MultiSubmodelProvider provider, AssetAdministrationShell shell) {
        Collection submodelRefs = shell.getSubmodelReferences();
        List<String> submodelIdentificationIds = this.getSubmodelIdentificationIdsFromSubmodelReferences(submodelRefs);
        List<String> submodelIdShorts = this.getSubmodelIdShortsFromSubmodelReferences(submodelRefs);
        submodelIdentificationIds = this.completeSubmodelIdentificationsIdsByIdShorts(submodelIdentificationIds, submodelIdShorts);
        this.createProviderForSubmodels(provider, submodelIdentificationIds);
    }

    private void createProviderForSubmodels(MultiSubmodelProvider provider, List<String> submodelIdentificationIds) {
        submodelIdentificationIds.forEach(submodelIdentificationId -> this.addSubmodelProvidersById((String)submodelIdentificationId, provider));
    }

    private List<String> completeSubmodelIdentificationsIdsByIdShorts(List<String> submodelIdentificationIds, List<String> submodelIdShorts) {
        submodelIdShorts.forEach(idShort -> {
            String id = this.getSubmodelIdByIdShort((String)idShort);
            if (id != null) {
                submodelIdentificationIds.add(id);
            }
        });
        return submodelIdentificationIds;
    }

    private List<String> getSubmodelIdentificationIdsFromSubmodelReferences(Collection<IReference> submodelRefs) {
        List<String> submodelIdentificationIds = submodelRefs.stream().map(this::getLastKeyFromReference).filter(lastKey -> lastKey.getIdType() != KeyType.IDSHORT).map(lastKey -> lastKey.getValue()).collect(Collectors.toList());
        return submodelIdentificationIds;
    }

    private List<String> getSubmodelIdShortsFromSubmodelReferences(Collection<IReference> submodelRefs) {
        List<String> submodelIdShorts = submodelRefs.stream().map(this::getLastKeyFromReference).filter(lastKey -> lastKey.getIdType() == KeyType.IDSHORT).map(lastKey -> lastKey.getValue()).collect(Collectors.toList());
        return submodelIdShorts;
    }

    private IKey getLastKeyFromReference(IReference reference) {
        List keys = reference.getKeys();
        IKey lastKey = (IKey)keys.get(keys.size() - 1);
        return lastKey;
    }

    private String getSubmodelIdByIdShort(String idShort) {
        Submodel submodel = (Submodel)this.submodelStorageApi.retrieve(idShort);
        if (submodel != null) {
            return submodel.getIdentification().getId();
        }
        return null;
    }

    private void addSubmodelProvidersById(String submodelIdentificationId, MultiSubmodelProvider provider) {
        MongoDBSubmodelAPI submodelApi = new MongoDBSubmodelAPI((BaSyxStorageAPI<Submodel>)this.submodelStorageApi, submodelIdentificationId);
        try {
            SubmodelProvider submodelProvider = new SubmodelProvider((ISubmodelAPI)submodelApi);
            provider.addSubmodel(submodelProvider);
        }
        catch (ResourceNotFoundException noSubmodelsInDB) {
            this.logger.warn("Could not add submodel with identificationId '{}'.", (Object)submodelIdentificationId);
        }
    }

    public Collection<IAssetAdministrationShell> getAASList() {
        return this.shellStorageApi.retrieveAll().stream().map(aas -> aas).collect(Collectors.toList());
    }

    public IAssetAdministrationShell getAAS(IIdentifier shellIdentification) {
        IModelProvider shellProvider = this.getAASProvider(shellIdentification);
        Map shellMap = (Map)shellProvider.getValue("/aas");
        return AssetAdministrationShell.createAsFacade((Map)shellMap);
    }

    public void createAAS(AssetAdministrationShell shell) {
        this.shellApiFactory.create(shell);
    }

    public void updateAAS(AssetAdministrationShell shell) {
        this.shellApiFactory.create(shell);
    }

    public void deleteAAS(IIdentifier shellIdentifier) {
        String shellIdentificationId = shellIdentifier.getId();
        this.shellStorageApi.delete(shellIdentificationId);
    }

    public MultiSubmodelProvider getProviderForAASId(String shellIdentificationId) {
        AssetAdministrationShell shell = (AssetAdministrationShell)this.shellStorageApi.retrieve(shellIdentificationId);
        IAASAPI shellApi = this.shellApiFactory.create(shell.getIdentification());
        MultiSubmodelProvider provider = this.createMultiSubmodelProvider(shellApi);
        this.addSubmodelsFromDB(provider, shell);
        return provider;
    }

    public IModelProvider getAASProvider(IIdentifier shellIdentificationId) {
        return this.getProviderForAASId(shellIdentificationId.getId());
    }
}

