/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx.security;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;

public class AuthenticationDescriptorBasedAuthenticationManager
implements AuthenticationManager {
    public static final IRoleAuthenticator<Authentication> AUTHENTICATOR = new IRoleAuthenticator<Authentication>(){

        public List<String> getRoles(Authentication subjectInformation) {
            List result = null;
            Object details = subjectInformation.getDetails();
            if (null != details) {
                result = CollectionUtils.toList((Object[])new String[]{details.toString()});
            }
            return result;
        }
    };
    private Map<String, AuthenticationDescriptor.IdentityTokenWithRole> users = new HashMap<String, AuthenticationDescriptor.IdentityTokenWithRole>();

    public AuthenticationDescriptorBasedAuthenticationManager(AuthenticationDescriptor desc) {
        for (AuthenticationDescriptor.IdentityTokenWithRole u : desc.getServerUsers()) {
            this.users.put(u.getUserName(), u);
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        AuthenticationDescriptor.IdentityTokenWithRole user = this.users.get(username);
        if (null != user) {
            String presentedPassword = (String)authentication.getCredentials();
            String pwPrefix = "";
            String tea = user.getTokenEncryptionAlgorithm();
            if ("UTF-8".equalsIgnoreCase(tea)) {
                pwPrefix = "{noop}";
            } else if ("BCRYPT".equalsIgnoreCase(tea)) {
                pwPrefix = "{bcrypt}";
            } else if ("SHA256".equalsIgnoreCase(tea)) {
                pwPrefix = "{sha256}";
            }
            if (PasswordEncoderFactories.createDelegatingPasswordEncoder().matches((CharSequence)presentedPassword, pwPrefix + user.getTokenDataAsString())) {
                UsernamePasswordAuthenticationToken tok = UsernamePasswordAuthenticationToken.authenticated((Object)user, (Object)user.getTokenDataAsString(), null);
                tok.setDetails((Object)user.getRole());
                return tok;
            }
            throw new BadCredentialsException("Presented password/token for user " + username + " does not match.");
        }
        throw new UsernameNotFoundException("User " + username + " unknown.");
    }
}

