/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.authorization.internal;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.IAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IIdentifiable;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedAASAggregator<SubjectInformationType>
implements IAASAggregator {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-aggregator:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-aggregator:write";
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedAASAggregator.class);
    protected final IAASAggregator decoratedAasAggregator;
    protected final IAASAggregatorAuthorizer<SubjectInformationType> aasAggregatorAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedAASAggregator(IAASAggregator decoratedAasAggregator, IAASAggregatorAuthorizer<SubjectInformationType> aasAggregatorAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.decoratedAasAggregator = decoratedAasAggregator;
        this.aasAggregatorAuthorizer = aasAggregatorAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedAasAggregator.getAASList();
        }
        try {
            return this.authorizeGetAASList();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected Collection<IAssetAdministrationShell> authorizeGetAASList() throws InhibitException {
        return this.getAASIdentifierList().stream().map(identifier -> {
            try {
                return this.authorizeGetAAS((IIdentifier)identifier);
            }
            catch (InhibitException e) {
                logger.info(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Collection<IIdentifier> getAASIdentifierList() throws InhibitException {
        Collection<IAssetAdministrationShell> authorizedAASList = this.aasAggregatorAuthorizer.authorizeGetAASList(this.subjectInformationProvider.get(), this.decoratedAasAggregator::getAASList);
        return authorizedAASList.stream().map(IIdentifiable::getIdentification).collect(Collectors.toList());
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier shellId) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedAasAggregator.getAAS(shellId);
        }
        try {
            return this.authorizeGetAAS(shellId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected IAssetAdministrationShell authorizeGetAAS(IIdentifier aasId) throws InhibitException {
        return this.aasAggregatorAuthorizer.authorizeGetAAS(this.subjectInformationProvider.get(), aasId, () -> this.decoratedAasAggregator.getAAS(aasId));
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier shellId) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedAasAggregator.getAASProvider(shellId);
        }
        try {
            return this.authorizeGetAASProvider(shellId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected IModelProvider authorizeGetAASProvider(IIdentifier aasId) throws ResourceNotFoundException, InhibitException {
        return this.aasAggregatorAuthorizer.authorizeGetAASProvider(this.subjectInformationProvider.get(), aasId, () -> this.decoratedAasAggregator.getAASProvider(aasId));
    }

    @Override
    public void createAAS(AssetAdministrationShell shell) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedAasAggregator.createAAS(shell);
            return;
        }
        try {
            this.authorizeCreateAAS(shell);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedAasAggregator.createAAS(shell);
    }

    protected void authorizeCreateAAS(AssetAdministrationShell aas) throws InhibitException {
        this.aasAggregatorAuthorizer.authorizeCreateAAS(this.subjectInformationProvider.get(), aas);
    }

    @Override
    public void updateAAS(AssetAdministrationShell shell) throws ResourceNotFoundException {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedAasAggregator.updateAAS(shell);
            return;
        }
        try {
            this.authorizeUpdateAAS(shell);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedAasAggregator.updateAAS(shell);
    }

    protected void authorizeUpdateAAS(AssetAdministrationShell aas) throws InhibitException {
        this.aasAggregatorAuthorizer.authorizeUpdateAAS(this.subjectInformationProvider.get(), aas);
    }

    @Override
    public void deleteAAS(IIdentifier shellId) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedAasAggregator.deleteAAS(shellId);
            return;
        }
        try {
            this.authorizeDeleteAAS(shellId);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedAasAggregator.deleteAAS(shellId);
    }

    protected void authorizeDeleteAAS(IIdentifier aasId) throws InhibitException {
        this.aasAggregatorAuthorizer.authorizeDeleteAAS(this.subjectInformationProvider.get(), aasId);
    }
}

