/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.api.mqtt;

import org.eclipse.basyx.aas.restapi.observing.IAASAPIObserver;
import org.eclipse.basyx.aas.restapi.observing.ObservableAASAPI;
import org.eclipse.basyx.extensions.aas.api.mqtt.MqttAASAPIHelper;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttAASAPIObserver
extends MqttEventService
implements IAASAPIObserver {
    private static Logger logger = LoggerFactory.getLogger(MqttAASAPIObserver.class);
    private String aasIdShort;

    public MqttAASAPIObserver(MqttClient client, String aasIdShort) throws MqttException {
        super(client);
        this.connectMqttClientIfRequired();
        this.aasIdShort = aasIdShort;
    }

    public MqttAASAPIObserver(MqttClient client, String aasIdShort, MqttConnectOptions options) throws MqttException {
        super(client);
        this.connectMqttClientIfRequired(options);
        this.aasIdShort = aasIdShort;
    }

    @Deprecated
    public MqttAASAPIObserver(ObservableAASAPI observedAPI, String serverEndpoint, String clientId) throws MqttException {
        this(observedAPI, serverEndpoint, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    @Deprecated
    public MqttAASAPIObserver(ObservableAASAPI observedAPI, String brokerEndpoint, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(new MqttClient(brokerEndpoint, clientId, persistence), MqttAASAPIHelper.getAASIdShort(observedAPI));
        logger.info("Create new MQTT AASAPI for endpoint " + brokerEndpoint);
        observedAPI.addObserver(this);
    }

    @Deprecated
    public MqttAASAPIObserver(ObservableAASAPI observedAPI, String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        this(observedAPI, serverEndpoint, clientId, user, pw, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    @Deprecated
    public MqttAASAPIObserver(ObservableAASAPI observedAPI, String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence persistence) throws MqttException {
        this(new MqttClient(serverEndpoint, clientId, persistence), MqttAASAPIHelper.getAASIdShort(observedAPI), MqttAASAPIHelper.getMqttConnectOptions(user, pw));
        logger.info("Create new MQTT AASAPI for endpoint " + serverEndpoint);
        observedAPI.addObserver(this);
    }

    @Deprecated
    public MqttAASAPIObserver(ObservableAASAPI observedAPI, MqttClient client) throws MqttException {
        this(client, MqttAASAPIHelper.getAASIdShort(observedAPI));
        observedAPI.addObserver(this);
    }

    private void connectMqttClientIfRequired() throws MqttException {
        if (!this.mqttClient.isConnected()) {
            this.mqttClient.connect();
        }
    }

    private void connectMqttClientIfRequired(MqttConnectOptions options) throws MqttException {
        if (!this.mqttClient.isConnected()) {
            this.mqttClient.connect(options);
        }
    }

    @Override
    public void submodelAdded(IReference submodelReference) {
        for (IKey key : submodelReference.getKeys()) {
            if (!key.getType().name().equalsIgnoreCase("Submodel")) continue;
            String id = key.getValue();
            this.sendMqttMessage("BaSyxAAS_addedSubmodelReference", MqttAASAPIObserver.getCombinedMessage(this.aasIdShort, id));
        }
    }

    @Override
    public void submodelRemoved(String id) {
        this.sendMqttMessage("BaSyxAAS_removedSubmodelReference", MqttAASAPIObserver.getCombinedMessage(this.aasIdShort, id));
    }

    public static String getCombinedMessage(String aasId, String idShort) {
        return "(" + aasId + "," + idShort + ")";
    }
}

