/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization;

import java.util.Optional;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextAuthorizer {
    public void throwExceptionInCaseOfInsufficientAuthorization(String requiredAuthority) {
        Optional<Authentication> authentication = this.getAuthentication();
        if (!authentication.isPresent()) {
            throw new ProviderException("Access denied for unauthenticated requestor");
        }
        if (!this.hasRequiredAuthority(authentication.get(), requiredAuthority)) {
            throw new ProviderException("Access denied as required authority is missing for requestor");
        }
    }

    private Optional<Authentication> getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return Optional.ofNullable(context.getAuthentication());
    }

    private boolean hasRequiredAuthority(Authentication authentication, String requiredAuthority) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(requiredAuthority::equals);
    }
}

