/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.basyx.extensions.shared.authorization.internal.TargetInformation;

public class RbacRule {
    private String role;
    private String action;
    private TargetInformation targetInformation;

    public RbacRule(String role, String action, TargetInformation targetInformation) {
        if (Objects.isNull(role)) {
            throw new IllegalArgumentException("role must not be null");
        }
        if (Objects.isNull(action)) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (Objects.isNull(targetInformation)) {
            throw new IllegalArgumentException("targetInformation must not be null");
        }
        this.role = role;
        this.action = action;
        this.targetInformation = targetInformation;
    }

    public String getRole() {
        return this.role;
    }

    public String getAction() {
        return this.action;
    }

    public TargetInformation getTargetInformation() {
        return this.targetInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbacRule)) {
            return false;
        }
        RbacRule rbacRule = (RbacRule)o;
        return new EqualsBuilder().append((Object)this.getRole(), (Object)rbacRule.getRole()).append((Object)this.getAction(), (Object)rbacRule.getAction()).append((Object)this.getTargetInformation(), (Object)rbacRule.getTargetInformation()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getRole()).append((Object)this.getAction()).append((Object)this.getTargetInformation()).toHashCode();
    }

    public String toString() {
        return "RbacRule{" + "role='" + this.role + '\'' + ", action='" + this.action + '\'' + ", targetInformation='" + this.targetInformation + '\'' + '}';
    }
}

