/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyXMLConverter
extends SubmodelElementXMLConverter {
    private static Logger logger = LoggerFactory.getLogger(PropertyXMLConverter.class);
    public static final String PROPERTY = "aas:property";

    public static Property parseProperty(Map<String, Object> xmlObject) {
        Property property = new Property();
        PropertyXMLConverter.populateSubmodelElement(xmlObject, property);
        String valueType = XMLHelper.getString(xmlObject.get("aas:valueType"));
        String xmlStringValue = XMLHelper.getString(xmlObject.get("aas:value"));
        ValueType propertyType = XMLHelper.convertAASXValueTypeToLocal(valueType);
        Object propertyValue = XMLHelper.convertAASXValueToLocal(xmlStringValue, propertyType);
        Map xmlValueId = (Map)xmlObject.get("aas:valueId");
        Reference valueId = ReferenceXMLConverter.parseReference(xmlValueId);
        property.set(propertyValue, propertyType);
        if (valueId != null) {
            property.setValueId(valueId);
        }
        return property;
    }

    public static Element buildProperty(Document document, IProperty prop) {
        String valueType;
        Element propertyRoot = document.createElement(PROPERTY);
        PropertyXMLConverter.populateSubmodelElement(document, propertyRoot, prop);
        String value = null;
        IReference valueId = prop.getValueId();
        if (valueId != null) {
            Element valueIdRoot = document.createElement("aas:valueId");
            valueIdRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, valueId));
            propertyRoot.appendChild(valueIdRoot);
        }
        try {
            Object valueObj = prop.getValue();
            value = valueObj == null ? null : valueObj.toString();
        }
        catch (Exception e) {
            logger.error("Exeption in buildProperty!", (Throwable)e);
        }
        if (value != null) {
            Element valueEle = document.createElement("aas:value");
            valueEle.appendChild(document.createTextNode(value));
            propertyRoot.appendChild(valueEle);
        }
        if ((valueType = prop.getValueType().toString()) != null) {
            Element valueTypeElem = document.createElement("aas:valueType");
            valueTypeElem.appendChild(document.createTextNode(valueType));
            propertyRoot.appendChild(valueTypeElem);
        }
        return propertyRoot;
    }
}

