/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua;

import java.net.InetAddress;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;

public class CertificateHelper {
    private boolean buildDefault = true;
    private KeyPair keyPair;
    private X509Certificate certificate;
    private String commonName;
    private String organization;
    private String organizationalUnit;
    private String locality;
    private String state;
    private String countryCode;
    private String applicationUri;
    private Set<InetAddress> ipAddresses = new HashSet<InetAddress>();
    private Set<String> dnsNames = new CopyOnWriteArraySet<String>();

    public CertificateHelper() {
        try {
            this.keyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
        }
        catch (NoSuchAlgorithmException impossible) {
            throw new AssertionError("Every Java implementation is required to implement 2048 bit RSA", impossible);
        }
    }

    public KeyPair getKeyPair() {
        if (this.certificate == null) {
            throw new IllegalStateException("Must build certificate first.");
        }
        return this.keyPair;
    }

    public X509Certificate getCertificate() {
        if (this.certificate == null) {
            throw new IllegalStateException("Must build certificate first.");
        }
        return this.certificate;
    }

    public CertificateHelper setCommonName(String commonName) {
        this.buildDefault = false;
        this.commonName = commonName;
        return this;
    }

    public CertificateHelper setOrganization(String organization) {
        this.buildDefault = false;
        this.organization = organization;
        return this;
    }

    public CertificateHelper setOrganizationalUnit(String organizationalUnit) {
        this.buildDefault = false;
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public CertificateHelper setLocality(String locality) {
        this.buildDefault = false;
        this.locality = locality;
        return this;
    }

    public CertificateHelper setState(String state) {
        this.buildDefault = false;
        this.state = state;
        return this;
    }

    public CertificateHelper setCountryCode(String countryCode) {
        this.buildDefault = false;
        this.countryCode = countryCode;
        return this;
    }

    public CertificateHelper setApplicationUri(String applicationUri) {
        this.buildDefault = false;
        this.applicationUri = applicationUri;
        return this;
    }

    public CertificateHelper addDnsName(String dnsName) {
        this.buildDefault = false;
        this.dnsNames.add(dnsName);
        return this;
    }

    public CertificateHelper addIpAddress(InetAddress ipAddress, boolean lookupHostName) {
        this.buildDefault = false;
        this.ipAddresses.add(ipAddress);
        if (lookupHostName) {
            CompletableFuture.supplyAsync(ipAddress::getHostName).thenAccept(hostName -> this.dnsNames.add((String)hostName));
        }
        return this;
    }

    public void build() throws CertificateException {
        try {
            SelfSignedCertificateBuilder builder = this.buildDefault ? this.configureDefaultBuilder() : this.configureBuilderWithInfo();
            this.certificate = builder.build();
        }
        catch (Exception e) {
            throw new CertificateException("Failed to create self-signed certificate.", e);
        }
    }

    private SelfSignedCertificateBuilder configureDefaultBuilder() {
        return new SelfSignedCertificateBuilder(this.keyPair).setCommonName("Unknown");
    }

    private SelfSignedCertificateBuilder configureBuilderWithInfo() {
        SelfSignedCertificateBuilder builder = new SelfSignedCertificateBuilder(this.keyPair).setCommonName(this.commonName).setOrganization(this.organization).setOrganizationalUnit(this.organizationalUnit).setLocalityName(this.locality).setStateName(this.state).setCountryCode(this.countryCode).setApplicationUri(this.applicationUri);
        this.ipAddresses.forEach(ip -> builder.addIpAddress(ip.getHostName()));
        this.dnsNames.forEach(arg_0 -> ((SelfSignedCertificateBuilder)builder).addDnsName(arg_0));
        return builder;
    }
}

