/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.connector.milo;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.basyx.vab.protocol.opcua.exception.OpcUaException;
import org.eclipse.milo.opcua.stack.core.BuiltinReferenceType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;

public final class BrowsePathHelper {
    private static final String REFERENCE_TYPE_SPLIT = "(?<!&)[\\/\\.\\<]";
    private static final String NAMESPACE_SPLIT = "(?<!&):";
    private String path;
    private int index;

    private BrowsePathHelper(String path) {
        this.path = path;
        this.index = 0;
    }

    public static BrowsePath parse(String s) throws OpcUaException {
        org.eclipse.basyx.vab.protocol.opcua.types.NodeId root = new org.eclipse.basyx.vab.protocol.opcua.types.NodeId(Identifiers.RootFolder);
        return BrowsePathHelper.parse(root, s);
    }

    public static BrowsePath parse(org.eclipse.basyx.vab.protocol.opcua.types.NodeId startingNode, String s) throws OpcUaException {
        RelativePathElement elem;
        if (startingNode == null || s == null) {
            throw new IllegalArgumentException("startingNode and s must not be null.");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("s must not be empty.");
        }
        BrowsePathHelper helper = new BrowsePathHelper(s);
        LinkedList<RelativePathElement> elements = new LinkedList<RelativePathElement>();
        while ((elem = helper.next()) != null) {
            elements.add(elem);
        }
        RelativePathElement[] arr = elements.toArray(new RelativePathElement[0]);
        RelativePath relativePath = new RelativePath(arr);
        return new BrowsePath(startingNode.getInternalId(), relativePath);
    }

    public static BrowsePath getParent(BrowsePath browsePath) {
        if (browsePath == null) {
            throw new IllegalArgumentException("browsePath must not be null.");
        }
        RelativePathElement[] targetElements = browsePath.getRelativePath().getElements();
        if (targetElements.length == 0) {
            throw new IllegalArgumentException("Can't generate browse path to parent of an empty path.");
        }
        RelativePathElement[] parentElements = Arrays.copyOf(targetElements, targetElements.length - 1);
        RelativePath parentPath = new RelativePath(parentElements);
        return new BrowsePath(browsePath.getStartingNode(), parentPath);
    }

    public static String toString(RelativePath relativePath) {
        StringBuilder sb = new StringBuilder();
        RelativePathElement[] elems = relativePath.getElements();
        for (int i = 0; i < elems.length; ++i) {
            if (BrowsePathHelper.isAllHierarchicalReferences(elems[i])) {
                sb.append('/');
            } else if (BrowsePathHelper.isAllAggregatesReferences(elems[i])) {
                sb.append('.');
            } else {
                throw new IllegalArgumentException("relativePath contains directly specified references which aren't supported.");
            }
            if (elems[i].getTargetName() != null) {
                sb.append(BrowsePathHelper.qualifiedNameToString(elems[i].getTargetName()));
                continue;
            }
            if (i == elems.length - 1) continue;
            throw new IllegalArgumentException("Only the last element in a relative path is allowed to have no name.");
        }
        return sb.toString();
    }

    private static boolean isAllHierarchicalReferences(RelativePathElement rpe) {
        return rpe.getReferenceTypeId().equals((Object)BuiltinReferenceType.HierarchicalReferences.getNodeId()) && rpe.getIsInverse() == false && rpe.getIncludeSubtypes() != false;
    }

    private static boolean isAllAggregatesReferences(RelativePathElement rpe) {
        return rpe.getReferenceTypeId().equals((Object)BuiltinReferenceType.Aggregates.getNodeId()) && rpe.getIsInverse() == false && rpe.getIncludeSubtypes() != false;
    }

    private static String qualifiedNameToString(QualifiedName qn) {
        return qn.getNamespaceIndex().toString() + ":" + qn.getName();
    }

    private RelativePathElement next() {
        if (this.index >= this.path.length()) {
            return null;
        }
        NodeId referenceType = this.parseReferenceType();
        QualifiedName qualifiedName = this.parseQualifiedName();
        return new RelativePathElement(referenceType, Boolean.valueOf(false), Boolean.valueOf(true), qualifiedName);
    }

    private NodeId parseReferenceType() {
        switch (this.path.charAt(this.index)) {
            case '/': {
                ++this.index;
                return BuiltinReferenceType.HierarchicalReferences.getNodeId();
            }
            case '.': {
                ++this.index;
                return BuiltinReferenceType.Aggregates.getNodeId();
            }
            case '<': {
                throw new IllegalArgumentException("This helper doesn't supported directly specified reference types.");
            }
        }
        throw new OpcUaException(String.format("Invalid browse path at index %d: %s", this.index, this.path));
    }

    private QualifiedName parseQualifiedName() {
        QualifiedName qn;
        if (this.index == this.path.length()) {
            return null;
        }
        String pathElement = this.path.substring(this.index).split(REFERENCE_TYPE_SPLIT, 2)[0];
        String[] s = pathElement.split(NAMESPACE_SPLIT, 3);
        if (s.length == 1) {
            qn = this.parseQualifiedName(s[0]);
        } else if (s.length == 2) {
            qn = this.parseQualifiedName(s[0], s[1]);
        } else {
            throw new OpcUaException(String.format("Not a valid relative path element starting at index %d: %s", this.index, this.path));
        }
        this.index += pathElement.length();
        return qn;
    }

    private QualifiedName parseQualifiedName(String browseName) {
        String unescaped = this.unescape(browseName);
        if (unescaped.isEmpty()) {
            throw new OpcUaException(String.format("Browse path contains invalid browse name at index %d: %s", this.index, this.path));
        }
        return new QualifiedName(0, unescaped);
    }

    private QualifiedName parseQualifiedName(String namespaceIndex, String browseName) {
        int ns;
        try {
            ns = Integer.parseUnsignedInt(namespaceIndex);
        }
        catch (NumberFormatException e) {
            throw new OpcUaException(String.format("Browse path contains invalid namespace index at index %d: %s", this.index, this.path));
        }
        String escaped = this.unescape(browseName);
        if (escaped.isEmpty()) {
            throw new OpcUaException(String.format("Browse path contains invalid browse name at index %d: %s", this.index, this.path));
        }
        return new QualifiedName(ns, escaped);
    }

    private String unescape(String s) {
        return s.replace("&", "");
    }
}

