/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.registry.restapi;

import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.registry.api.IVABRegistryService;
import org.eclipse.basyx.vab.registry.memory.VABInMemoryRegistry;

public class VABRegistryModelProvider
implements IModelProvider {
    private IVABRegistryService directory;

    public VABRegistryModelProvider(IVABRegistryService directory) {
        this.directory = directory;
    }

    public VABRegistryModelProvider() {
        this(new VABInMemoryRegistry());
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        return this.directory.lookup(path);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        throw new RuntimeException("Set not supported by VAB Directory");
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        this.directory.addMapping(path, (String)newEntity);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        this.directory.removeMapping(path);
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new RuntimeException("Delete with parameter not supported by VAB Directory");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new RuntimeException("Invoke not supported by VAB Directory");
    }
}

