/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.authorization.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryFeature;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedTaggedDirectoryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.IAASRegistryDecorator;
import org.eclipse.basyx.components.registry.authorization.internal.ITaggedDirectoryDecorator;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.extensions.aas.directory.tagged.authorized.internal.SimpleRbacTaggedDirectoryAuthorizer;
import org.eclipse.basyx.extensions.aas.registration.authorization.internal.SimpleRbacAASRegistryAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.PredefinedSetRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSet;
import org.eclipse.basyx.extensions.shared.authorization.internal.RbacRuleSetDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRbacAuthorizedAASRegistryFeature<SubjectInformationType>
extends AuthorizedAASRegistryFeature {
    private static Logger logger = LoggerFactory.getLogger(SimpleRbacAuthorizedAASRegistryFeature.class);

    public SimpleRbacAuthorizedAASRegistryFeature(BaSyxSecurityConfiguration securityConfig) {
        super(securityConfig);
    }

    @Override
    public IAASRegistryDecorator getAASRegistryDecorator() {
        logger.info("use SimpleRbac authorization strategy");
        RbacRuleSet rbacRuleSet = this.getRbacRuleSet();
        PredefinedSetRbacRuleChecker rbacRuleChecker = new PredefinedSetRbacRuleChecker(rbacRuleSet);
        IRoleAuthenticator<SubjectInformationType> roleAuthenticator = this.getRoleAuthenticator();
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        return new AuthorizedAASRegistryDecorator<SubjectInformationType>(new SimpleRbacAASRegistryAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), subjectInformationProvider);
    }

    @Override
    public ITaggedDirectoryDecorator getTaggedDirectoryDecorator() {
        logger.info("use SimpleRbac authorization strategy");
        RbacRuleSet rbacRuleSet = this.getRbacRuleSet();
        PredefinedSetRbacRuleChecker rbacRuleChecker = new PredefinedSetRbacRuleChecker(rbacRuleSet);
        IRoleAuthenticator<SubjectInformationType> roleAuthenticator = this.getRoleAuthenticator();
        ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider = this.getSubjectInformationProvider();
        return new AuthorizedTaggedDirectoryDecorator<SubjectInformationType>(new SimpleRbacTaggedDirectoryAuthorizer((IRbacRuleChecker)rbacRuleChecker, roleAuthenticator), subjectInformationProvider);
    }

    public RbacRuleSet getRbacRuleSet() {
        try {
            return new RbacRuleSetDeserializer().fromFile(this.securityConfig.getAuthorizationStrategySimpleRbacRulesFilePath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IRoleAuthenticator<SubjectInformationType> getRoleAuthenticator() {
        return (IRoleAuthenticator)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.simpleRbac.roleAuthenticator", IRoleAuthenticator.class);
    }

    private ISubjectInformationProvider<SubjectInformationType> getSubjectInformationProvider() {
        return (ISubjectInformationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.simpleRbac.subjectInformationProvider", ISubjectInformationProvider.class);
    }
}

