/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.model.VABModelMap;

public abstract class ModelDescriptor
extends VABModelMap<Object> {
    public static final String ENDPOINTS = "endpoints";

    protected ModelDescriptor() {
        this.putAll(new ModelType(this.getModelType()));
    }

    public ModelDescriptor(Map<String, Object> map) {
        this();
        this.putAll(map);
    }

    public ModelDescriptor(String idShort, IIdentifier id, String httpEndpoint) {
        this();
        this.put("idShort", idShort);
        Identifier identifierMap = new Identifier(id.getIdType(), id.getId());
        this.put("identification", identifierMap);
        Map<String, Object> endpointWrapper = this.convertEndpointToMap(httpEndpoint, "http");
        this.setEndpoints(Arrays.asList(endpointWrapper));
    }

    public IIdentifier getIdentifier() {
        Map identifierModel = (Map)this.get("identification");
        return Identifier.createAsFacade(identifierModel);
    }

    public String getIdShort() {
        return Referable.createAsFacade(this, null).getIdShort();
    }

    public void addEndpoint(String endpoint) {
        Collection<Map<String, Object>> endpointsCollection = this.getEndpoints();
        Map<String, Object> endpointWrapper = this.convertEndpointToMap(endpoint, "http");
        endpointsCollection.add(endpointWrapper);
        this.setEndpoints(endpointsCollection);
    }

    public void removeEndpoint(String endpoint) {
        Collection<Map<String, Object>> endpointsCollection = this.getEndpoints();
        Iterator<Map<String, Object>> iterator = endpointsCollection.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> endpointMap = iterator.next();
            if (!endpointMap.containsKey("address") || endpointMap.get("address") == null || !endpointMap.get("address").toString().equalsIgnoreCase(endpoint)) continue;
            iterator.remove();
            break;
        }
        this.setEndpoints(endpointsCollection);
    }

    public String getFirstEndpoint() {
        Object e = this.get(ENDPOINTS);
        if (e instanceof Collection) {
            Collection endpoints = (Collection)e;
            if (endpoints.isEmpty()) {
                return "";
            }
            return (String)((Map)endpoints.iterator().next()).get("address");
        }
        return "";
    }

    public Collection<Map<String, Object>> getEndpoints() {
        Object endpoints = this.get(ENDPOINTS);
        if (endpoints instanceof Collection) {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            for (Map endpointMap : (Collection)endpoints) {
                ret.add(endpointMap);
            }
            return ret;
        }
        return new ArrayList<Map<String, Object>>();
    }

    protected void validate(Map<String, Object> map) {
        if (!map.containsKey("idShort") || !(map.get("idShort") instanceof String)) {
            throw new MalformedRequestException(this.getModelType() + " is missing idShort entry");
        }
        if (!map.containsKey("identification") || !(map.get("identification") instanceof Map)) {
            throw new MalformedRequestException(this.getModelType() + " is missing identification entry");
        }
        if (!map.containsKey(ENDPOINTS) || !(map.get(ENDPOINTS) instanceof Collection)) {
            throw new MalformedRequestException(this.getModelType() + " is missing endpoints entry");
        }
    }

    protected abstract String getModelType();

    private Map<String, Object> convertEndpointToMap(String endpoint, String type) {
        LinkedHashMap<String, Object> endpointWrapper = new LinkedHashMap<String, Object>();
        endpointWrapper.put("type", type);
        endpointWrapper.put("address", endpoint);
        return endpointWrapper;
    }

    private void setEndpoints(Collection<Map<String, Object>> endpointsCollection) {
        this.put(ENDPOINTS, endpointsCollection);
    }
}

