/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.descriptor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUrn
extends Identifier {
    private static Logger logger = LoggerFactory.getLogger(ModelUrn.class);

    private ModelUrn() {
        this.setIdType(IdentifierType.IRI);
    }

    public ModelUrn(String rawURN) {
        this();
        this.setId(rawURN);
    }

    public ModelUrn(String legalEntity, String subUnit, String subModel, String version, String revision, String elementId, String elementInstance) {
        this();
        StringBuffer urnBuilder = new StringBuffer();
        urnBuilder.append("urn:");
        if (legalEntity != null) {
            urnBuilder.append(legalEntity);
        }
        urnBuilder.append(":");
        if (subUnit != null) {
            urnBuilder.append(subUnit);
        }
        urnBuilder.append(":");
        if (subModel != null) {
            urnBuilder.append(subModel);
        }
        urnBuilder.append(":");
        if (version != null) {
            urnBuilder.append(version);
        }
        urnBuilder.append(":");
        if (revision != null) {
            urnBuilder.append(revision);
        }
        urnBuilder.append(":");
        if (elementId != null) {
            urnBuilder.append(elementId);
        }
        if (elementInstance != null) {
            urnBuilder.append("#" + elementInstance);
        }
        this.setId(urnBuilder.toString());
    }

    public String getURN() {
        return this.getId();
    }

    public String getEncodedURN() {
        try {
            return URLEncoder.encode(this.getId(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Exception in getEncodedURN", (Throwable)e);
            return null;
        }
    }

    public ModelUrn append(String suffix) {
        return new ModelUrn(this.getId() + suffix);
    }
}

