/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.observing;

import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.observing.IAASRegistryServiceObserverV2;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.observer.Observable;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ObservableAASRegistryServiceV2
extends Observable<IAASRegistryServiceObserverV2>
implements IAASRegistry {
    private IAASRegistry aasRegistry;
    private String registryId = "aas-registry";

    public ObservableAASRegistryServiceV2(IAASRegistry registry, String registryId) {
        this.aasRegistry = registry;
        this.registryId = registryId;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        try {
            this.aasRegistry.lookupAAS(deviceAASDescriptor.getIdentifier());
            this.aasRegistry.register(deviceAASDescriptor);
            this.observers.stream().forEach(o -> o.aasUpdated(deviceAASDescriptor, this.registryId));
        }
        catch (ResourceNotFoundException e) {
            this.aasRegistry.register(deviceAASDescriptor);
            this.observers.stream().forEach(o -> o.aasRegistered(deviceAASDescriptor, this.registryId));
        }
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        try {
            this.aasRegistry.lookupSubmodel(aas, smDescriptor.getIdentifier());
            this.aasRegistry.register(aas, smDescriptor);
            this.observers.stream().forEach(o -> o.submodelUpdated(aas, smDescriptor, this.registryId));
        }
        catch (ResourceNotFoundException e) {
            this.aasRegistry.register(aas, smDescriptor);
            this.observers.stream().forEach(o -> o.submodelRegistered(aas, smDescriptor, this.registryId));
        }
    }

    @Override
    public void delete(IIdentifier aasId) throws ProviderException {
        AASDescriptor aasDescriptor = this.lookupAAS(aasId);
        this.aasRegistry.delete(aasId);
        this.observers.stream().forEach(o -> o.aasDeleted(aasDescriptor, this.registryId));
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        SubmodelDescriptor smDescriptor = this.lookupSubmodel(aasId, smId);
        this.aasRegistry.delete(aasId, smId);
        this.observers.stream().forEach(o -> o.submodelDeleted(aasId, smDescriptor, this.registryId));
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasId) throws ProviderException {
        return this.aasRegistry.lookupAAS(aasId);
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        return this.aasRegistry.lookupAll();
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        return this.aasRegistry.lookupSubmodels(aasId);
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        return this.aasRegistry.lookupSubmodel(aasId, smId);
    }
}

