/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.api.authorization.internal;

import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.extensions.aas.api.authorization.internal.IAASAPIAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.ISubjectInformationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;

public class AuthorizedAASAPI<SubjectInformationType>
implements IAASAPI {
    public static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-api:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-api:write";
    protected final IAASAPI decoratedAASAPI;
    protected final IAASAPIAuthorizer<SubjectInformationType> aasAPIAuthorizer;
    protected final ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider;

    public AuthorizedAASAPI(IAASAPI decoratedAASAPI, IAASAPIAuthorizer<SubjectInformationType> aasAPIAuthorizer, ISubjectInformationProvider<SubjectInformationType> subjectInformationProvider) {
        this.decoratedAASAPI = decoratedAASAPI;
        this.aasAPIAuthorizer = aasAPIAuthorizer;
        this.subjectInformationProvider = subjectInformationProvider;
    }

    @Override
    public IAssetAdministrationShell getAAS() {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            return this.decoratedAASAPI.getAAS();
        }
        try {
            return this.authorizeGetAAS();
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
    }

    protected IAssetAdministrationShell authorizeGetAAS() throws InhibitException {
        return this.aasAPIAuthorizer.authorizeGetAAS(this.subjectInformationProvider.get(), this.decoratedAASAPI::getAAS);
    }

    @Override
    public void addSubmodel(IReference submodel) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedAASAPI.addSubmodel(submodel);
            return;
        }
        try {
            this.authorizeAddSubmodel(submodel);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedAASAPI.addSubmodel(submodel);
    }

    protected void authorizeAddSubmodel(IReference smId) throws InhibitException {
        this.aasAPIAuthorizer.authorizeAddSubmodel(this.subjectInformationProvider.get(), this.decoratedAASAPI::getAAS, smId);
    }

    @Override
    public void removeSubmodel(String smIdShortPath) {
        if (ElevatedCodeAuthentication.isCodeAuthentication()) {
            this.decoratedAASAPI.removeSubmodel(smIdShortPath);
            return;
        }
        try {
            this.authorizeRemoveSubmodel(smIdShortPath);
        }
        catch (InhibitException e) {
            throw new NotAuthorizedException(e);
        }
        this.decoratedAASAPI.removeSubmodel(smIdShortPath);
    }

    protected void authorizeRemoveSubmodel(String smIdShortPath) throws InhibitException {
        this.aasAPIAuthorizer.authorizeRemoveSubmodel(this.subjectInformationProvider.get(), this.decoratedAASAPI::getAAS, smIdShortPath);
    }
}

